
<?php $__env->startSection('title'); ?>
Order Details
<?php $__env->stopSection(); ?>
<?php $__env->startSection('css'); ?>
<!---Internal Fileupload css-->
<link href="<?php echo e(URL::asset('assets/plugins/fileuploads/css/fileupload.css')); ?>" rel="stylesheet" type="text/css"/>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
	<!-- row -->
	<div class="row row-sm mt-3">

		<!-- Order start -->
		<div class="col-sm-12">
			<div class="card pt-4 box-shadow-0">
				<div class="card-body">

					<table class="table">
						<thead class="bg-primary py-3">
						  <tr>
							<th class="text-white py-3" scope="col">#Invoice</th>
							<th class="text-white py-3" scope="col"><?php echo e($order->invoice_no); ?></th>
						  </tr>
						</thead>
						<tbody>
						  <tr>
							<th scope="row">fullname</th>
							<td><?php echo e($order->fullname); ?></td>
						  </tr>
						  <tr>
							<th scope="row">phone</th>
							<td><?php echo e($order->phone); ?></td>
						  </tr>
						  <tr>
							<th scope="row">address</th>
							<td><?php echo e($order->address); ?></td>
						  </tr>
						  <tr>
							<th scope="row">area</th>
							<td><?php echo e(isset($order->area) ? $order->area->name_en : ''); ?></td>
						  </tr>
						  <tr>
							<th scope="row">floor number</th>
							<td><?php echo e($order->floor_number); ?></td>
						  </tr>
						  <tr>
							<th scope="row">payment method</th>
							<td><?php echo e($order->payment_method); ?></td>
						  </tr>
						  <tr>
							<th scope="row">status</th>
							<td>
								<select name="status" class="form-control" data-order-id="<?php echo e($order->id); ?>">
									<option value="pending" <?php echo e($order->status == 'pending' ? 'selected' : ''); ?>>pending</option>
									<option value="complete" <?php echo e($order->status == 'complete' ? 'selected' : ''); ?>>complete</option>
									<option value="declined" <?php echo e($order->status == 'declined' ? 'selected' : ''); ?>>declined</option>
									<option value="failed" <?php echo e($order->status == 'failed' ? 'selected' : ''); ?>>failed</option>
								</select>
							</td>
						  </tr>
						  <?php if($order->note): ?>
						  <tr>
							<th scope="row">note</th>
							<td><?php echo e($order->note); ?></td>
						  </tr>
						  <?php endif; ?>
						  <tr>
							<th scope="row">date</th>
							<td><?php echo e(date('d M Y', strtotime($order->created_at))); ?></td>
						  </tr>
						  <tr>
							<th scope="row">subtotal</th>
							<td><?php echo e($order_total->subtotal); ?> L:E</td>
						  </tr>
						  <tr>
							<th scope="row">delivery fees</th>
							<td><?php echo e($order_total->delivery_fees); ?> L:E</td>
						  </tr>
						  <tr>
							<th scope="row">extra fees</th>
							<td><?php echo e($order_total->extra_fees); ?> L:E</td>
						  </tr>
						  <tr>
							<th scope="row">coupon discount</th>
							<td><?php echo e($order_total->coupon_discount); ?> L:E</td>
						  </tr>
						  <tr>
							<th scope="row">total</th>
							<td><?php echo e($order_total->total); ?> L:E</td>
						  </tr>
						</tbody>
					</table>
	
				</div>
			</div>
		</div>
		<!-- Order END -->

		<?php $__currentLoopData = $order_products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order_product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
			<!-- Order Product start -->
			<div class="col-sm-12">
				<div class="card pt-4 box-shadow-0">
					<div class="card-body">

						<table class="table">
							<thead class="bg-primary py-3">
								<tr>
									<th class="text-white py-3" scope="col">Product</th>
									<th class="text-white py-3" scope="col">
										<a href="<?php echo e(url('admin/products/'.$order_product->product_id.'')); ?>" class="text-white">
											<?php echo e($order_product->name); ?> <i class="fa fa-eye"></i>
										</a>
									</th>
								</tr>
							</thead>
							<tbody>
								<tr>
									<th scope="row">price</th>
									<td><?php echo e($order_product->price); ?></td>
								</tr>
								<tr>
									<th scope="row">quantity</th>
									<td>x<?php echo e($order_product->quantity); ?></td>
								</tr>
								<tr>
									<th scope="row">total</th>
									<td><?php echo e($order_product->total); ?></td>
								</tr>
							</tbody>
						</table>
		
					</div>
				</div>
			</div>
			<!-- Order Product END -->
		<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

	</div>
	<!-- row -->

</div>
<!-- Container closed -->
</div>
<!-- main-content closed -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
	<script type="text/javascript">

		function updateStatus(data) {

			var ajaxPromise = ajaxRequest('POST', "<?php echo e(route('updateOrderStatus')); ?>", data);


			ajaxPromise.done(function(response) {
				swalAlert(response.message, '' ,response.status);
			});

			ajaxPromise.fail(function(xhr, status, error) {
				swalAlert('Request failed', '' ,0);
				console.log('Request failed:', error);
			});

		}

		$(document).ready(function() {

			$.ajaxSetup({
				headers: {
					'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
				} 
			});

			// updateStatus
			$('select[name="status"]').on('change', function(e) {
				e.preventDefault();

				var data = {
                    "status" : $(this).val(),
                    "order_id" : $(this).data('order-id'),
                };
				updateStatus(data);
			});

		});
	</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp\htdocs\masterfit-admin\resources\views/orders/form.blade.php ENDPATH**/ ?>