
<?php $__env->startSection('title'); ?>
	<?php echo e(isset($workout) ? 'Edit workout': 'Add workout'); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('css'); ?>
<!---Internal Fileupload css-->
<link href="<?php echo e(URL::asset('assets/plugins/fileuploads/css/fileupload.css')); ?>" rel="stylesheet" type="text/css"/>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('page-header'); ?>
	<!-- breadcrumb -->
	<div class="breadcrumb-header justify-content-between">
		<div class="my-auto">
			<div class="d-flex">
				<h4 class="content-title mb-0 my-auto">workout</h4><span class="text-muted mt-1 tx-13 mr-2 mb-0">/ <?php echo e(isset($workout) ? 'Edit': 'Create'); ?></span>
			</div>
		</div>
	</div>
	<!-- breadcrumb -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
	<!-- row -->
	<div class="row row-sm">

		<!-- workout form start -->
		<div class="col-sm-12">
			<div class="card pt-4 box-shadow-0">
				<div class="card-body pt-0">
					<form class="form-horizontal row" method="POST" action="<?php echo e(isset($workout) ? Route('workouts.update', ['workout'=>$workout->id]) : Route('workouts.store')); ?>" enctype="multipart/form-data">
						<?php echo csrf_field(); ?>

						<div class="form-group col-12">
							<label class="text-capitalize" for="category_id">Category</label>
							<select name="category_id" id="category_id" class="form-control" required>
								<option value="" disabled selected>Choose Category</option>
								<?php $category_id = isset($workout) ? $workout->category_id : ''; ?>
								<?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
									<option value="<?php echo e($category->id); ?>" <?php echo e($category_id == $category->id ? 'selected': ''); ?>><?php echo e($category->name); ?></option>
								<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
							</select>
							<?php if($errors->has('category_id')): ?>
								<p class="help text-danger"><?php echo e($errors->first('category_id')); ?></p>
							<?php endif; ?>
						</div>

						<div class="form-group col-12">
							<label class="text-capitalize" for="title">title</label>
							<input type="text" class="form-control" name="title" id="title" required value="<?php echo e(isset($workout) ? $workout->title : old('title')); ?>" placeholder="Enter title">
							<?php if($errors->has('title')): ?>
								<p class="help text-danger"><?php echo e($errors->first('title')); ?></p>
							<?php endif; ?>
						</div>

						<div class="form-group col-12">
							<label class="text-capitalize" for="overview">overview</label>
							<input type="text" class="form-control" name="overview" id="overview" required value="<?php echo e(isset($workout) ? $workout->overview : old('overview')); ?>" placeholder="Enter overview">
							<?php if($errors->has('overview')): ?>
								<p class="help text-danger"><?php echo e($errors->first('overview')); ?></p>
							<?php endif; ?>
						</div>

						<div class="form-group col-12">
							<label class="text-capitalize" for="description">description</label>
							<textarea name="description" id="editor" rows="10" class="form-control">
								<?php echo e(isset($workout) ? $workout->description : old('description')); ?>

							</textarea>
							<?php if($errors->has('description')): ?>
								<p class="help text-danger"><?php echo e($errors->first('description')); ?></p>
							<?php endif; ?>
						</div>

						<div class="form-group col-12">
							<label class="text-capitalize" for="difficulty">Difficulty</label>
							<select name="difficulty" id="difficulty" class="form-control" required>
								<option value="" disabled selected>Choose Difficulty</option>
								<?php $difficulty = isset($workout) ? $workout->difficulty : ''; ?>
								<option value="Beginner" <?php echo e($difficulty == "Beginner" ? 'selected': ''); ?>>Beginner</option>
								<option value="Intermediate" <?php echo e($difficulty == "Intermediate" ? 'selected': ''); ?>>Intermediate</option>
								<option value="Advanced" <?php echo e($difficulty == "Advanced" ? 'selected': ''); ?>>Advanced</option>
							</select>
							<?php if($errors->has('difficulty')): ?>
								<p class="help text-danger"><?php echo e($errors->first('difficulty')); ?></p>
							<?php endif; ?>
						</div>

						<div class="form-group col-12">
							<label class="text-capitalize" for="duration">duration (in seconds)</label>
							<input type="number" class="form-control" name="duration" id="duration" min="30" max="7200" required value="<?php echo e(isset($workout) ? $workout->duration : old('duration')); ?>" placeholder="Enter duration">
							<?php if($errors->has('duration')): ?>
								<p class="help text-danger"><?php echo e($errors->first('duration')); ?></p>
							<?php endif; ?>
						</div>

						<!-- img Upload -->
						<div class="col-12">
							<div class="row">
								<div class="col-md-12">
									<div class="card">

										<div class="card-body">
											<div>
												<h6 class="card-title mb-1">image Upload</h6>
											</div>
											<div class="row mb-4">
												<div class="col-sm-12 col-md-4">
													<input type="file" name="main_image" accept="image/*" class="dropify" data-height="200" />
												</div>
												<?php if(isset($workout)): ?>
												<div class="col-lg-4 col-md-12 mb-4 mb-lg-0">
													<img
														src="<?php echo e(config('app.uploads')); ?><?php echo e($workout->main_image); ?>"
														class="shadow-1-strong rounded mb-4 img-fluid"
														alt="<?php echo e($workout->title); ?>"
														style="max-height: 210px; min-height: 210px;"
													/>
												</div>
												<?php endif; ?>
											</div>
										</div>
										<?php if($errors->has('main_image')): ?>
											<p class="help text-danger"><?php echo e($errors->first('main_image')); ?></p>
										<?php endif; ?>
									</div>
								</div>
							</div>
						</div>
						<!-- img Upload closed -->



						<div class="form-group col-12 mb-0 mt-3 justify-content-end">
							<div>
								<button type="submit" class="btn btn-primary"><?php echo e(isset($workout) ? 'Update': 'Create'); ?></button>
							</div>
						</div>
					</form>
				</div>
			</div>
		</div>
		<!-- workout form END -->

	</div>
	<!-- row -->

	<!-- Video Upload -->
	<?php if(isset($workout)): ?>
	<!-- row -->
	<div class="row row-sm">
		<!-- workout form start -->
		<div class="col-sm-12">
			<div class="card pt-4 box-shadow-0">
				<div class="card-body pt-0">
					<form class="form-horizontal row" method="POST" action="<?php echo e(route("upload/video/workout")); ?>" enctype="multipart/form-data">
						<?php echo csrf_field(); ?>
						<input type="hidden" name="record_id" value="<?php echo e($workout->id); ?>">
						<input type="hidden" name="title" value="<?php echo e($workout->title); ?>">
						<input type="hidden" name="description" value="<?php echo e($workout->overview); ?>">
						<div class="col-12">
							<div class="row">
								<div class="col-md-12">
									<div class="card">

										<div class="card-body">
											<div>
												<h6 class="card-title mb-1">Video Upload</h6>
											</div>
											<div class="row mb-4">
												<div class="col-sm-12 col-md-4">
													<input type="file" name="video" accept="video/*" class="dropify" data-height="200" />
												</div>
												<?php if(isset($workout)): ?>
												<div class="col-lg-4 col-md-12 mb-4 mb-lg-0">
													<iframe src="<?php echo e($workout->player_embed_url); ?>" width="640" height="360" frameborder="0" allow="autoplay; fullscreen; picture-in-picture; clipboard-write; encrypted-media" title="<?php echo e($workout->title); ?>"></iframe>
												</div>
												<?php endif; ?>
											</div>
										</div>
										<?php if($errors->has('video')): ?>
											<p class="help text-danger"><?php echo e($errors->first('video')); ?></p>
										<?php endif; ?>
									</div>
								</div>
							</div>
						</div>
						<div class="form-group col-12 mb-0 mt-3 justify-content-end">
							<div>
								<button type="submit" class="btn btn-primary">Upload Video</button>
							</div>
						</div>
					</form>
				</div>
			</div>
		</div>
		<!-- workout form END -->
	</div>
	<!-- row -->
	<?php endif; ?>
	<!-- Video Upload -->

</div>
<!-- Container closed -->
</div>
<!-- main-content closed -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<!--Internal Fileuploads js-->
<script src="<?php echo e(URL::asset('assets/plugins/fileuploads/js/fileupload.js')); ?>"></script>
<script src="<?php echo e(URL::asset('assets/plugins/fileuploads/js/file-upload.js')); ?>"></script>
<!-- Include the CKEditor library -->
<script src="https://cdn.ckeditor.com/ckeditor5/36.0.1/classic/ckeditor.js"></script>

<!-- Initialize CKEditor -->
<script>
    ClassicEditor
        .create(document.querySelector('#editor'))
        .catch(error => {
            console.error(error);
        });
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp\htdocs\fitnasyum\resources\views/workouts/form.blade.php ENDPATH**/ ?>