
<?php $__env->startSection('title'); ?>
	<?php echo e(isset($service) ? 'Edit service': 'Add service'); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('css'); ?>
<!---Internal Fileupload css-->
<link href="<?php echo e(URL::asset('assets/plugins/fileuploads/css/fileupload.css')); ?>" rel="stylesheet" type="text/css"/>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('page-header'); ?>
	<!-- breadcrumb -->
	<div class="breadcrumb-header justify-content-between">
		<div class="my-auto">
			<div class="d-flex">
				<h4 class="content-title mb-0 my-auto">service</h4><span class="text-muted mt-1 tx-13 mr-2 mb-0">/ <?php echo e(isset($service) ? 'Edit': 'Create'); ?></span>
			</div>
		</div>
	</div>
	<!-- breadcrumb -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
	<!-- row -->
	<div class="row row-sm">

		<!-- service form start -->
		<div class="col-sm-12">
			<div class="card pt-4 box-shadow-0">
				<div class="card-body pt-0">
					<form class="form-horizontal row" method="POST" action="<?php echo e(isset($service) ? Route('services.update', ['service'=>$service->id]) : Route('services.store')); ?>" enctype="multipart/form-data">
						<?php echo csrf_field(); ?>
						<div class="form-group col-12">
							<label class="text-capitalize" for="title">title</label>
							<input type="text" class="form-control" name="title" id="title" required value="<?php echo e(isset($service) ? $service->title : old('title')); ?>" placeholder="Enter title">
							<?php if($errors->has('title')): ?>
								<p class="help text-danger"><?php echo e($errors->first('title')); ?></p>
							<?php endif; ?>
						</div>

						<div class="form-group col-12">
							<label class="text-capitalize" for="overview">overview</label>
							<input type="text" class="form-control" name="overview" id="overview" required value="<?php echo e(isset($service) ? $service->overview : old('overview')); ?>" placeholder="Enter overview">
							<?php if($errors->has('overview')): ?>
								<p class="help text-danger"><?php echo e($errors->first('overview')); ?></p>
							<?php endif; ?>
						</div>

						<div class="form-group col-12">
							<label class="text-capitalize" for="description">description</label>
							<textarea name="description" id="editor" rows="10" class="form-control">
								<?php echo e(isset($service) ? $service->description : old('description')); ?>

							</textarea>
							<?php if($errors->has('description')): ?>
								<p class="help text-danger"><?php echo e($errors->first('description')); ?></p>
							<?php endif; ?>
						</div>

						<!-- img Upload -->
						<div class="col-12">
							<div class="row">
								<div class="col-md-12">
									<div class="card">

										<div class="card-body">
											<div>
												<h6 class="card-title mb-1">image Upload</h6>
											</div>
											<div class="row mb-4">
												<div class="col-sm-12 col-md-4">
													<input type="file" name="main_image" accept="image/*" class="dropify" data-height="200" />
												</div>
												<?php if(isset($service)): ?>
												<div class="col-lg-4 col-md-12 mb-4 mb-lg-0">
													<img
														src="<?php echo e($base_uploads_url); ?><?php echo e($service->main_image); ?>"
														class="w-100 shadow-1-strong rounded mb-4 img-fluid"
														alt="<?php echo e($service->title); ?>"
														style="max-height: 210px; min-height: 210px;"
													/>
												</div>
												<?php endif; ?>
											</div>
										</div>
										<?php if($errors->has('main_image')): ?>
											<p class="help text-danger"><?php echo e($errors->first('main_image')); ?></p>
										<?php endif; ?>
									</div>
								</div>
							</div>
						</div>
						<!-- img Upload closed -->

						<!-- video Upload -->
						<div class="col-12">
							<div class="row">
								<div class="col-md-12">
									<div class="card">

										<div class="card-body">
											<div>
												<h6 class="card-title mb-1">Video Upload</h6>
											</div>
											<div class="row mb-4">
												<div class="col-sm-12 col-md-4">
													<input type="file" name="video" accept="video/*" class="dropify" data-height="200" />
												</div>
												<?php if(isset($service->video)): ?>
												<div class="col-lg-4 col-md-12 mb-4 mb-lg-0">
													<video src="<?php echo e($base_uploads_url); ?><?php echo e($service->video); ?>" height="300"></video>
												</div>
												<?php endif; ?>
											</div>
										</div>
										<?php if($errors->has('video')): ?>
											<p class="help text-danger"><?php echo e($errors->first('video')); ?></p>
										<?php endif; ?>
									</div>
								</div>
							</div>
						</div>
						<!-- video Upload closed -->

						<div class="form-group col-12 mb-0 mt-3 justify-content-end">
							<div>
								<button type="submit" class="btn btn-primary"><?php echo e(isset($service) ? 'Update': 'Create'); ?></button>
							</div>
						</div>
					</form>
				</div>
			</div>
		</div>
		<!-- service form END -->

	</div>
	<!-- row -->

</div>
<!-- Container closed -->
</div>
<!-- main-content closed -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<!--Internal Fileuploads js-->
<script src="<?php echo e(URL::asset('assets/plugins/fileuploads/js/fileupload.js')); ?>"></script>
<script src="<?php echo e(URL::asset('assets/plugins/fileuploads/js/file-upload.js')); ?>"></script>

<!-- Include the CKEditor library -->
<script src="https://cdn.ckeditor.com/ckeditor5/36.0.1/classic/ckeditor.js"></script>

<!-- Initialize CKEditor -->
<script>
    ClassicEditor
        .create(document.querySelector('#editor'), {
            language: 'ar', //Arabic for RTL
           
        })
        .catch(error => {
            console.error(error);
        });
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\lavie-admin\resources\views/services/form.blade.php ENDPATH**/ ?>