
<?php $__env->startSection('title'); ?>
	<?php echo e(isset($booking) ? 'Edit Registration': 'Add Registration'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-header'); ?>
	<!-- breadcrumb -->
	<div class="breadcrumb-header justify-content-between">
		<div class="my-auto">
			<div class="d-flex">
				<h4 class="content-title mb-0 my-auto">Registration</h4><span class="text-muted mt-1 tx-13 mr-2 mb-0">/ <?php echo e(isset($booking) ? 'Edit': 'Create'); ?></span>
			</div>
			<?php if(isset($doctors)): ?>
			<div class="d-flex">
				<h4 class="content-title mt-3 tx-16">(<?php echo e(count($doctors)); ?>) <span class="text-primary">Doctors Registered</span></h4>
			</div>
			<?php endif; ?>
		</div>
	</div>
	<!-- breadcrumb -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

	<div class="loader-container hidden">
		<div class="spinner-border"></div>
	</div>

	<!-- row -->
	<div class="row row-sm">

		
		<div class="col-sm-12">
			<div class="card pt-4 box-shadow-0">
				<div class="card-body pt-0">
					<form class="form-horizontal row" id="booking-form" method="POST" action="<?php echo e(isset($booking) ? Route('bookings.update', ['booking'=>$booking->id]) : Route('bookings.store')); ?>" enctype="multipart/form-data">
						<?php echo csrf_field(); ?>


						<table class="table">
							<thead class="bg-primary py-3">
							  <tr>
								<th class="text-white py-3" scope="col">Item</th>
								<th class="text-white py-3" scope="col">Description</th>
							  </tr>
							</thead>
							<tbody>
							  <tr>
								<th scope="row">firstname</th>
								<td><input type="text" class="form-control" name="firstname" required value="<?php echo e(isset($booking) ? $booking->firstname : old('firstname')); ?>" placeholder="Enter firstname"></td>
							  </tr>
							  <tr>
								<th scope="row">lastname</th>
								<td><input type="text" class="form-control" name="lastname" required value="<?php echo e(isset($booking) ? $booking->lastname : old('lastname')); ?>" placeholder="Enter lastname"></td>
							  </tr>
							  <tr>
								<th scope="row">title</th>
								<td><input type="text" class="form-control" name="title" required value="<?php echo e(isset($booking) ? $booking->title : old('title')); ?>" placeholder="Enter title"></td>
							  </tr>
							  <tr>
								<th scope="row">company</th>
								<td><input type="text" class="form-control" name="company" required value="<?php echo e(isset($booking) ? $booking->company : old('company')); ?>" placeholder="Enter company"></td>
							  </tr>
							  <tr>
								<th scope="row">mobile</th>
								<td><input type="text" class="form-control" name="mobile" required value="<?php echo e(isset($booking) ? $booking->mobile : old('mobile')); ?>" placeholder="Enter mobile"></td>
							  </tr>
							  <tr>
								<th scope="row">email</th>
								<td><input type="text" class="form-control" name="email" required value="<?php echo e(isset($booking) ? $booking->email : old('email')); ?>" placeholder="Enter email"></td>
							  </tr>
							  <tr>
								<th scope="row">address</th>
								<td><input type="text" class="form-control" name="address" required value="<?php echo e(isset($booking) ? $booking->address : old('address')); ?>" placeholder="Enter address"></td>
							  </tr>
							  <tr>
								<th scope="row">region</th>
								<td><input type="text" class="form-control" name="region" value="<?php echo e(isset($booking) ? $booking->region : old('region')); ?>" placeholder="Enter region"></td>
							  </tr>
							  <tr>
								<th scope="row">governorate</th>
								<td><input type="text" class="form-control" name="governorate" required value="<?php echo e(isset($booking) ? $booking->governorate : old('governorate')); ?>" placeholder="Enter governorate"></td>
							  </tr>
							  <tr>
								<th scope="row">country</th>
								<td><input type="text" class="form-control" name="country" required value="<?php echo e(isset($booking) ? $booking->country : old('country')); ?>" placeholder="Enter country"></td>
							  </tr>
							  <tr>
								<th scope="row">telephone</th>
								<td><input type="text" class="form-control" name="telephone" value="<?php echo e(isset($booking) ? $booking->telephone : old('telephone')); ?>" placeholder="Enter telephone"></td>
							  </tr>
							  <tr>
								<th scope="row">website</th>
								<td><input type="text" class="form-control" name="website" value="<?php echo e(isset($booking) ? $booking->website : old('website')); ?>" placeholder="Enter website"></td>
							  </tr>
							  <tr>
								<th scope="row">specialization</th>
								<td>
									<?php isset($booking) ? $specialization = $booking->specialization :  $specialization = '';?>
									<select name="specialization" required class="form-control">
										<option value="Retail Shop" <?php echo e($specialization == 'Retail Shop' ? 'selected' : ''); ?>>Retail Shop (محل قطاعي)</option>
										<option value="Wholesale Shop" <?php echo e($specialization == 'Wholesale Shop' ? 'selected' : ''); ?>>Wholesale Shop (محل جملة)</option>
										<option value="Factory / Workshop" <?php echo e($specialization == 'Factory / Workshop' ? 'selected' : ''); ?>>Factory / Workshop (مصنع / ورشة)</option>
										<option value="Sales" <?php echo e($specialization == 'Sales' ? 'selected' : ''); ?>>Sales (مندوب مبيعات)</option>
										<option value="Others" <?php echo e($specialization == 'Others' ? 'selected' : ''); ?>>Others (أخري)</option>
									</select>
								</td>
							  </tr>
							  <tr>
								<th scope="row">source of knowledge</th>
								<td>
									<?php isset($booking) ? $src_of_know = $booking->source_of_knowledge :  $src_of_know = '';?>
									<select name="source_of_knowledge" required class="form-control">
										<option value="Facebook" <?php echo e($src_of_know == 'Facebook' ? 'selected' : ''); ?>>Facebook (فيسبوك)</option>
										<option value="Friend" <?php echo e($src_of_know == 'Friend' ? 'selected' : ''); ?>>Friend (صديق)</option>
										<option value="SMS" <?php echo e($src_of_know == 'SMS' ? 'selected' : ''); ?>>SMS (رسائل موبايل)</option>
										<option value="Radio" <?php echo e($src_of_know == 'Radio' ? 'selected' : ''); ?>>Radio (راديو)</option>
										<option value="Invitaion" <?php echo e($src_of_know == 'Invitaion' ? 'selected' : ''); ?>>Invitaion (دعوة)</option>
										<option value="Flyer" <?php echo e($src_of_know == 'Flyer' ? 'selected' : ''); ?>>Flyer (فلاير)</option>
										<option value="Internet" <?php echo e($src_of_know == 'Internet' ? 'selected' : ''); ?>>Internet (الإنترنت)</option>
										<option value="Outdoor" <?php echo e($src_of_know == 'Outdoor' ? 'selected' : ''); ?>>Outdoor (أوت دور)</option>
										<option value="Phone Call" <?php echo e($src_of_know == 'Phone Call' ? 'selected' : ''); ?>>Phone Call (مكالمة تليفونية)</option>
										<option value="Others" <?php echo e($src_of_know == 'Others' ? 'selected' : ''); ?>>Others (أخري)</option>
									</select>
								</td>
							  </tr>

							<?php if(isset($booking->qrcode->time_in)): ?>
							<tr>
								<th scope="row">Check-in</th>
								<td><?php echo e(date('d M Y - h:i a', strtotime($booking->qrcode->time_in))); ?></td>
							</tr>
							<?php endif; ?>
							<?php if(isset($booking->qrcode->time_out)): ?>
							<tr>
								<th scope="row">Check-out</th>
								<td><?php echo e(date('d M Y - h:i a', strtotime($booking->qrcode->time_out))); ?></td>
							</tr>
							<?php endif; ?>

							<?php if(isset($booking)): ?>
							<?php $print_badge = $booking->printBadge($booking->id); ?>
							<?php if($print_badge['count'] > 0): ?>
							<tr>
								<th scope="row">Print Badge Stats</th>
								<td><?php echo e($print_badge['date']); ?> ,, Total Prints <span class="text-primary">(<?php echo e($print_badge['count']); ?>)</span></td>
							</tr>
							<?php endif; ?>
							<?php endif; ?>
							

							</tbody>
						</table>

						<div class="form-group col-12 mb-0 mt-3 justify-content-end">
							<div>
								<button type="submit" class="btn btn-primary <?php echo e(isset($booking) ? '': 'create-booking'); ?>"><?php echo e(isset($booking) ? 'Update': 'Create'); ?></button>
							</div>
						</div>
					</form>
				</div>
			</div>
		</div>

	</div>
	<!-- row -->

</div>
<!-- Container closed -->
</div>
<!-- main-content closed -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>

<!--sweetalert js -->
<script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
<script>

	function formValidationCheck($form) {
		var status = 1;
		var message;
		$form.each(function(){
			var input = $(this);
			if( $(this).prop('required') && $(this).val() == '') {
				inputName = $(this).attr('name');
				message = inputName + " field can't be empty";
				status = 0;
			}
		});

		return {
			'status' : status,
			'message' : message,
		};
	}

	function sendFormAjax(data) {
		// showing loading
		$('.loader-container').removeClass('hidden');

		var icon;
		$.ajax({
			type: "POST",
			url: "<?php echo e(Route('bookings.store')); ?>",
			data: data,
			success: function(response) {
				// remove loading
				$('.loader-container').addClass('hidden');

				if(response.status == 1) {
					swal('Success!', response.message , 'success').then((result) => {
						sendAjaxPrint(response.record_id, 'badge');
					});
				} else {
					swal(response.message, '' , 'error');
				}
			}
		});
	}

	$(document).ready(function() {
		$.ajaxSetup({
			headers: {
				'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
			} 
		});

		// Form Submit
		$('.create-booking').on('click', function(e) {
			e.preventDefault();
			
			var formData = $("#booking-form").serialize();
			var formValidationRes = formValidationCheck( $("#booking-form :input") );
			if(formValidationRes['status'] == 0) {
				swal(formValidationRes['message'], '' , "warning");
			} else {
				sendFormAjax(formData);
			}
		});

	});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp\htdocs\smart_solutions_admin\resources\views/bookings/form.blade.php ENDPATH**/ ?>