<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Customer extends Model
{
    use HasFactory;

    protected $table = "ps_customer";

    protected $primaryKey = 'id_customer';

    protected $fillable = [
        'active',
        'deleted',
    ];

    public $timestamps = false;

    public function health_info() {
        return $this->hasOne(CustomerHealthInfo::class, 'id_customer', 'id_customer');
    }

}
