<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class Activity extends Model
{
    use HasFactory;
    
    protected $table = 'activities';

    protected $fillable = [
        'title',
        'type_id',
        'category_id',
        'overview',
        'description',
        'difficulty',
        'duration',
        'main_image',
    ];

    public function category() {
        return $this->belongsTo(Category::class);
    }
    
}
