
<?php $__env->startSection('title'); ?>
	<?php echo e(isset($user) ? 'Edit user': 'Add user'); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('page-header'); ?>
	<!-- breadcrumb -->
	<div class="breadcrumb-header justify-content-between">
		<div class="my-auto">
			<div class="d-flex">
				<h4 class="content-title mb-0 my-auto">user</h4><span class="text-muted mt-1 tx-13 mr-2 mb-0">/ <?php echo e(isset($user) ? 'Edit': 'Create'); ?></span>
			</div>
		</div>
	</div>
	<!-- breadcrumb -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
	<!-- row -->
	<div class="row row-sm">
		<div class="col-sm-12">
			<div class="card pt-4 box-shadow-0">
				<div class="card-body pt-0">
					<form class="form-horizontal row" method="POST" action="<?php echo e(isset($user) ? Route('users.update', ['user' => $user->id]) : Route('users.store')); ?>" enctype="multipart/form-data">
						<?php echo csrf_field(); ?>

						<div class="form-group col-6">
							<label class="text-capitalize" for="name">Name</label>
							<input type="text" class="form-control" name="name" id="name" required value="<?php echo e(isset($user) ? $user->name : old('name')); ?>" placeholder="Enter name">
							<?php if($errors->has('name')): ?>
								<p class="help text-danger"><?php echo e($errors->first('name')); ?></p>
							<?php endif; ?>
						</div>

						<div class="form-group col-6">
							<label class="text-capitalize" for="role">role</label>
							<select name="role" class="form-control" required>
								<?php isset($user) ? $user_role = $user->role : $user_role = ''; ?>
								<option value="" selected disabled>Select Role</option>
								<option value="usher" <?php echo e($user_role == 'usher' ? 'selected' : ''); ?>>Usher</option>
								<option value="admin" <?php echo e($user_role == 'admin' ? 'selected' : ''); ?>>Admin</option>
							</select>
							<?php if($errors->has('role')): ?>
								<p class="help text-danger"><?php echo e($errors->first('role')); ?></p>
							<?php endif; ?>
						</div>

						<div class="form-group col-6">
							<label class="text-capitalize" for="email">email</label>
							<input type="email" class="form-control" name="email" id="email" required value="<?php echo e(isset($user) ? $user->email : old('email')); ?>" placeholder="Enter email">
							<?php if($errors->has('email')): ?>
								<p class="help text-danger"><?php echo e($errors->first('email')); ?></p>
							<?php endif; ?>
						</div>

						<div class="form-group col-6">
							<label class="text-capitalize" for="password">password</label>
							<input type="password" class="form-control" name="password" id="password" autocomplete="new-password" placeholder="<?php echo e(isset($user) ? "*********" : "Enter password"); ?>">
							<?php if($errors->has('password')): ?>
								<p class="help text-danger"><?php echo e($errors->first('password')); ?></p>
							<?php endif; ?>
						</div>

						<div class="form-group col-12 mb-0 mt-3 justify-content-end">
							<div>
								<button type="submit" class="btn btn-primary"><?php echo e(isset($user) ? 'Update': 'Create'); ?></button>
							</div>
						</div>
					</form>
				</div>
			</div>
		</div>
	</div>
	<!-- row -->

</div>
<!-- Container closed -->
</div>
<!-- main-content closed -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp\htdocs\hvac_admin\resources\views/users/form.blade.php ENDPATH**/ ?>