
<?php $__env->startSection('title'); ?>
	<?php echo e(isset($offer) ? 'Edit offer': 'Add offer'); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('css'); ?>
<!-- Internal Select2 css -->
<link href="<?php echo e(URL::asset('assets/plugins/select2/css/select2.min.css')); ?>" rel="stylesheet">
<!--Internal  Datetimepicker-slider css -->
<link href="<?php echo e(URL::asset('assets/plugins/amazeui-datetimepicker/css/amazeui.datetimepicker.css')); ?>" rel="stylesheet">
<link href="<?php echo e(URL::asset('assets/plugins/jquery-simple-datetimepicker/jquery.simple-dtpicker.css')); ?>" rel="stylesheet">
<link href="<?php echo e(URL::asset('assets/plugins/pickerjs/picker.min.css')); ?>" rel="stylesheet">
<!---Internal Fileupload css-->
<link href="<?php echo e(URL::asset('assets/plugins/fileuploads/css/fileupload.css')); ?>" rel="stylesheet" type="text/css"/>

<!-- Internal Spectrum-colorpicker css -->
<link href="<?php echo e(URL::asset('assets/plugins/spectrum-colorpicker/spectrum.css')); ?>" rel="stylesheet">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('page-header'); ?>
	<!-- breadcrumb -->
	<div class="breadcrumb-header justify-content-between">
		<div class="my-auto">
			<div class="d-flex">
				<h4 class="content-title mb-0 my-auto">offer</h4><span class="text-muted mt-1 tx-13 mr-2 mb-0">/ <?php echo e(isset($offer) ? 'Edit': 'Create'); ?></span>
			</div>
		</div>
	</div>
	<!-- breadcrumb -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
	<!-- row -->
	<div class="row row-sm">
		<div class="col-sm-12">
			<div class="card pt-4 box-shadow-0">
				<div class="card-body pt-0">
					<form class="form-horizontal row" method="POST" action="<?php echo e(isset($offer) ? Route('offers.update', ['offer'=>$offer->id]) : Route('offers.store')); ?>" enctype="multipart/form-data">
						<?php echo csrf_field(); ?>
						<div class="form-group col-12">
							<label class="text-capitalize" for="title">offer Title</label>
							<input type="text" class="form-control" name="title" id="title" required value="<?php echo e(isset($offer) ? $offer->title : old('title')); ?>" placeholder="Enter offer title">
							<?php if($errors->has('title')): ?>
								<p class="help text-danger"><?php echo e($errors->first('title')); ?></p>
							<?php endif; ?>
						</div>
						<div class="form-group col-6">
							<label class="text-capitalize" for="type">type</label>
							<select class="form-control select2-no-search" name="offer_type" id="type" required>
								<option label="Choose one"></option>
								<?php if(isset($offer)): ?>
								<option value="appointment" <?php echo e($offer->offer_type == 'appointment' ? 'selected' : ''); ?>>appointment</option>
								<option value="home-visit" <?php echo e($offer->offer_type == 'home-visit' ? 'selected' : ''); ?>>home-visit</option>
								<option value="video-call" <?php echo e($offer->offer_type == 'video-call' ? 'selected' : ''); ?>>video-call</option>
								<?php else: ?>
								<option value="appointment">appointment</option>
								<option value="home-visit">home-visit</option>
								<option value="video-call">video-call</option>
								<?php endif; ?>
								
							</select>
							<?php if($errors->has('type')): ?>
								<p class="help text-danger"><?php echo e($errors->first('type')); ?></p>
							<?php endif; ?>
						</div>
						<div class="form-group col-6">
							<label class="text-capitalize" for="specialty">specialty</label>
							<?php
								isset($offer) ? $offerSpecialty = $offer->specialty : $offerSpecialty='';
							?>
							<select class="form-control" name="specialty" required>
								<option label="Choose one"></option>
								<?php $__currentLoopData = $specialities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $specialty): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
								<option value="<?php echo e($specialty->specialty); ?>" <?php echo e($specialty->specialty == $offerSpecialty ? 'selected' : ''); ?>>
									<?php echo e($specialty->specialty); ?>

								</option>
								<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
							</select>
							<?php if($errors->has('specialty')): ?>
								<p class="help text-danger"><?php echo e($errors->first('specialty')); ?></p>
							<?php endif; ?>
						</div>
						<div class="form-group col-6">
							<label class="text-capitalize" for="doctor_id">Doctor</label>
							<?php
								isset($offer) ? $doctor_id = $offer->doctor->id : $doctor_id='';
							?>
							<select class="form-control" name="docotor_id" required>
								<option label="Choose one"></option>
								<?php $__currentLoopData = $doctors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $doctor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
								<option value="<?php echo e($doctor->id); ?>" <?php echo e($doctor->id == $doctor_id ? 'selected' : ''); ?>>
									<?php echo e($doctor->name); ?>

								</option>
								<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
							</select>
							<?php if($errors->has('doctor_id')): ?>
								<p class="help text-danger"><?php echo e($errors->first('doctor_id')); ?></p>
							<?php endif; ?>
						</div>

						<div class="form-group col-6">
							<label class="text-capitalize" for="old_price">old price</label>
							<input type="number" class="form-control" name="old_price" id="old_price" required value="<?php echo e(isset($offer) ? $offer->old_price : old('old_price')); ?>" placeholder="Enter old price">
							<?php if($errors->has('old_price')): ?>
								<p class="help text-danger"><?php echo e($errors->first('old_price')); ?></p>
							<?php endif; ?>
						</div>
						<div class="form-group col-6">
							<label class="text-capitalize" for="new_price">new price</label>
							<input type="number" class="form-control" name="new_price" id="new_price" required value="<?php echo e(isset($offer) ? $offer->new_price : old('new_price')); ?>" placeholder="Enter new price">
							<?php if($errors->has('new_price')): ?>
								<p class="help text-danger"><?php echo e($errors->first('new_price')); ?></p>
							<?php endif; ?>
						</div>
						<div class="form-group col-6">
							<label class="text-capitalize" for="rate">rate</label>
							<input type="number" step="0.1" class="form-control" name="rate" id="rate" required value="<?php echo e(isset($offer) ? $offer->rate : old('rate')); ?>" placeholder="Enter rate">
							<?php if($errors->has('rate')): ?>
								<p class="help text-danger"><?php echo e($errors->first('rate')); ?></p>
							<?php endif; ?>
						</div>
						<div class="form-group col-12">
							<label class="text-capitalize" for="brief">brief</label>
							<textarea class="form-control" rows="3" name="brief" id="brief" placeholder="Enter offer Brief"><?php echo e(isset($offer) ? $offer->brief : old('brief')); ?></textarea>
							<?php if($errors->has('brief')): ?>
								<p class="help text-danger"><?php echo e($errors->first('brief')); ?></p>
							<?php endif; ?>
						</div>

						<div class="col-6">
							<label class="text-capitalize" for="creation_date">creation date</label>
							<div class="row row-sm mg-b-20">
								<div class="input-group col-md-12">
									<div class="input-group-prepend">
										<div class="input-group-text">
											<i class="typcn typcn-calendar-outline tx-24 lh--9 op-6"></i>
										</div>
									</div><input class="form-control fc-datepicker" name="creation_date" placeholder="MM/DD/YYYY" type="text" value="<?php echo e(isset($offer) ? $offer->creation_date : old('creation_date')); ?>" required>
								</div>
								<?php if($errors->has('creation_date')): ?>
									<p class="help text-danger"><?php echo e($errors->first('creation_date')); ?></p>
								<?php endif; ?>
							</div>
						</div>
						<div class="col-6">
							<label class="text-capitalize" for="expire_date">expire date</label>
							<div class="row row-sm mg-b-20">
								<div class="input-group col-md-12">
									<div class="input-group-prepend">
										<div class="input-group-text">
											<i class="typcn typcn-calendar-outline tx-24 lh--9 op-6"></i>
										</div>
									</div><input class="form-control fc-datepicker" name="expire_date" placeholder="MM/DD/YYYY" type="text" value="<?php echo e(isset($offer) ? $offer->expire_date : old('expire_date')); ?>" required>
								</div>
								<?php if($errors->has('expire_date')): ?>
									<p class="help text-danger"><?php echo e($errors->first('expire_date')); ?></p>
								<?php endif; ?>
							</div>
						</div>
						<!--Days Off-->
						<div class="col-12">
							<div class="card">
								<div class="card-body">
									<div class="main-content-label mg-b-20">
										Days Off
									</div>
									<?php
										$days = ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'];
										$i=0;
									?>
									<div class="row row-sm mg-b-20">
									<?php $__currentLoopData = $days; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $day): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
										<div class="form-group d-inline-block">
											<div class="checkbox">
												<div class="custom-checkbox custom-control">
													<?php if(isset($offer)): ?>
													<?php $daysOff = json_decode($offer->daysOff); ?>
													<input type="checkbox" data-checkboxes="mygroup" name="daysOff[<?php echo e($i); ?>]" value="1" class="custom-control-input" <?php echo e(in_array($i, $daysOff) ? 'checked' : ''); ?> id="daysOff_<?php echo e($i); ?>">
													<?php else: ?>
													<input type="checkbox" data-checkboxes="mygroup" name="daysOff[<?php echo e($i); ?>]" value="1" class="custom-control-input" id="daysOff_<?php echo e($i); ?>">
													<?php endif; ?>
													<label for="daysOff_<?php echo e($i); ?>" class="custom-control-label mt-1"> <?php echo e($day); ?></label>
												</div>
											</div>
										</div>
									<?php $i++;?>
									<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
									</div>									

									
								</div>
							</div>
						</div>
						<!--Days Off Closed-->

						<!--available_hours-->
						<div class="col-md-12 col-xl-12 col-xs-12 col-sm-12">
							<div class="card">
								<div class="card-body">
									<div class="main-content-label mg-b-20">
										Available hours
									</div>
									<?php
										$days = ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'];
										$i=0;
									?>
									<?php $__currentLoopData = $days; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $day): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
									<?php if(isset($offer)): ?>
									<?php $available_hours =  json_decode($offer->available_hours);?>
									<?php endif; ?>
									<div class="row row-sm mg-b-20">
										<div class="input-group wd-125 mr-3">
											<div class="input-group-prepend">
												<div class="input-group-text wd-125">
													<?php echo e($day); ?>

												</div>
											</div>
										</div>
										<div class="input-group col-6 col-md-4">
											<div class="input-group-prepend">
												<div class="input-group-text">
													From
												</div>
											</div><input class="form-control" name="from[<?php echo e($i); ?>]" value="<?php echo e(isset($offer) ?  $available_hours[$i]->from : ''); ?>" type="time" required>
										</div>
										<div class="input-group col-6 col-md-4">
											<div class="input-group-prepend">
												<div class="input-group-text">
													To
												</div>
											</div><input class="form-control" name="to[<?php echo e($i); ?>]" value="<?php echo e(isset($offer) ?  $available_hours[$i]->to : ''); ?>" type="time" required>
										</div>
									</div>									
									<?php $i++;?>
									<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
									
								</div>
							</div>
						</div>
						<!--available_hours Closed-->

						<!-- Image Upload -->
						<div class="col-12">
							<div class="row">
								<div class="col-md-12">
									<div class="card">
										<div class="card-body">
											<div>
												<h6 class="card-title mb-1">Images Upload</h6>
											</div>
											<div class="row mb-4">
												<div class="col-sm-12 col-md-4">
													<input type="file" name="imgs[]" multiple class="dropify" data-height="200" />
												</div>
											</div>
										</div>
										<?php if($errors->has('imgs')): ?>
											<p class="help text-danger"><?php echo e($errors->first('imgs')); ?></p>
										<?php endif; ?>
									</div>
								</div>
							</div>

							<div class="row">
								<?php if(isset($offer)): ?>
								
								<?php $images = explode(', ', $offer->imgs); ?>
		
								<?php $__currentLoopData = $images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
								<?php if($image == null): ?>
									<?php continue; ?>
								<?php endif; ?>
								<div class="col-lg-4 col-md-12 mb-4 mb-lg-0">
									<img
										src="<?php echo e(asset('/uploads/offers/'.$image)); ?>"
										class="w-100 shadow-1-strong rounded mb-4 img-fluid"
										alt="<?php echo e($offer->title); ?>"
										style="max-height: 280px; min-height: 280px;"
									/>
								</div>
								<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
								
								<?php endif; ?>
							</div>
						</div>
						<!-- Image Upload closed -->

						<div class="form-group col-12 mb-0 mt-3 justify-content-end">
							<div>
								<button type="submit" class="btn btn-primary"><?php echo e(isset($offer) ? 'Update': 'Create'); ?></button>
							</div>
						</div>
					</form>
				</div>
			</div>
		</div>
	</div>
	<!-- row -->

</div>
<!-- Container closed -->
</div>
<!-- main-content closed -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<!--Internal  Datepicker js -->
<script src="<?php echo e(URL::asset('assets/plugins/jquery-ui/ui/widgets/datepicker.js')); ?>"></script>
<!--Internal Fileuploads js-->
<script src="<?php echo e(URL::asset('assets/plugins/fileuploads/js/fileupload.js')); ?>"></script>
<script src="<?php echo e(URL::asset('assets/plugins/fileuploads/js/file-upload.js')); ?>"></script>

<!--Internal dynamicrows js-->
<script src="<?php echo e(URL::asset('assets/js/dynamicrows.js')); ?>"></script>

<!--Internal  jquery.maskedinput js -->
<script src="<?php echo e(URL::asset('assets/plugins/jquery.maskedinput/jquery.maskedinput.js')); ?>"></script>
<!--Internal  spectrum-colorpicker js -->
<script src="<?php echo e(URL::asset('assets/plugins/spectrum-colorpicker/spectrum.js')); ?>"></script>
<!-- Internal Select2.min js -->
<script src="<?php echo e(URL::asset('assets/plugins/select2/js/select2.min.js')); ?>"></script>
<!--Internal Ion.rangeSlider.min js -->
<script src="<?php echo e(URL::asset('assets/plugins/ion-rangeslider/js/ion.rangeSlider.min.js')); ?>"></script>
<!--Internal  jquery-simple-datetimepicker js -->
<script src="<?php echo e(URL::asset('assets/plugins/amazeui-datetimepicker/js/amazeui.datetimepicker.min.js')); ?>"></script>
<!-- Ionicons js -->
<script src="<?php echo e(URL::asset('assets/plugins/jquery-simple-datetimepicker/jquery.simple-dtpicker.js')); ?>"></script>
<!--Internal  pickerjs js -->
<script src="<?php echo e(URL::asset('assets/plugins/pickerjs/picker.min.js')); ?>"></script>
<!-- Internal form-elements js -->
<script src="<?php echo e(URL::asset('assets/js/form-elements.js')); ?>"></script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp\htdocs\moalj_admin\resources\views/offers/form.blade.php ENDPATH**/ ?>