
<?php $__env->startSection('page-header'); ?>
<!-- breadcrumb -->
<div class="breadcrumb-header justify-content-between">
	<div class="left-content">
		<div>
			<h2 class="main-content-title tx-24 mg-b-1 mg-b-lg-1">Hi, welcome back!</h2>
			<p class="mg-b-0">You can find here the statistics about the qrcodes</p>
		</div>
	</div>
</div>
<!-- /breadcrumb -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<div class="row py-4">
	<div class="col-12">

        <div class="card box-shadow-0">
			<form action="<?php echo e(url('admin/qrcodes')); ?>" method="POST">
				<?php echo csrf_field(); ?>
				<div class="card-header pb-0">
					<h4 class="card-title mb-0">Date</h4>
				</div>
				<div class="card-body">
					<div class="row">
						<div class="col-12 col-lg-3">
							<input type="date" class="form-control" name="date" value="<?php echo e($date); ?>" required>
						</div>
						<div class="col-12 col-lg-3 mt-3 mt-lg-0">
							<button class="btn btn-primary">Show Stats</button>
						</div>
					</div>
				</div>
			</form>
		</div>

		<?php if($result['total_qrcodes_in'] > 0): ?>
			
		<div class="card box-shadow-0 mt-4 p-2">
			<div class="card-header">
				<h4 class="card-title mb-0">QRCODES Stats in (<?php echo e($date); ?>)</h4>
			</div>

			<div class="card-body">

				<table class="table">
					<thead class="bg-primary py-3">
					  <tr>
						<th class="text-white py-3" scope="col">Item</th>
						<th class="text-white py-3" scope="col">Counter</th>
					  </tr>
					</thead>
					<tbody>
					  <tr>
						<th scope="row">Qrcodes In Now</th>
						<td><i class="fa fa-circle text-success"></i> <?php echo e($result['qrcodes_in_now']); ?></td>
					  </tr>
					  <tr>
						<th scope="row">Total Qrcodes In</th>
						<td><i class="fa fa-sign-in text-primary"></i> <?php echo e($result['total_qrcodes_in']); ?></td>
					  </tr>
					  <tr>
						<th scope="row">Total Qrcodes Out</th>
						<td><i class="fa fa-sign-out text-danger"></i> <?php echo e($result['total_qrcodes_out']); ?></td>
					  </tr>
					</tbody>
				  </table>

			</div>
		</div>

		<?php else: ?>
		<div class="alert alert-danger">There are no qrcodes in/out for this date</div>
		<?php endif; ?>


	</div>
</div>
	

</div>
<!-- Container closed -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<!--Internal  index js -->
<script src="<?php echo e(URL::asset('assets/js/index.js')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp\htdocs\smart_solutions_admin\resources\views/qrcodes/index.blade.php ENDPATH**/ ?>