
<?php $__env->startSection('title'); ?>
	<?php echo e(isset($faq) ? 'Edit faq': 'Add faq'); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('css'); ?>
<!---Internal Fileupload css-->
<link href="<?php echo e(URL::asset('assets/plugins/fileuploads/css/fileupload.css')); ?>" rel="stylesheet" type="text/css"/>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('page-header'); ?>
	<!-- breadcrumb -->
	<div class="breadcrumb-header justify-content-between">
		<div class="my-auto">
			<div class="d-flex">
				<h4 class="content-title mb-0 my-auto">faq</h4><span class="text-muted mt-1 tx-13 mr-2 mb-0">/ <?php echo e(isset($faq) ? 'Edit': 'Create'); ?></span>
			</div>
		</div>
	</div>
	<!-- breadcrumb -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
	<!-- row -->
	<div class="row row-sm">

		<!-- faq form start -->
		<div class="col-sm-12">
			<div class="card pt-4 box-shadow-0">
				<div class="card-body pt-0">
					<form class="form-horizontal row" method="POST" action="<?php echo e(isset($faq) ? Route('faqs.update', ['faq'=>$faq->id]) : Route('faqs.store')); ?>" enctype="multipart/form-data">
						<?php echo csrf_field(); ?>

						<div class="form-group col-12">
							<label class="text-capitalize" for="question">question</label>
							<input type="text" class="form-control" name="question" id="question" required value="<?php echo e(isset($faq) ? $faq->question : old('question')); ?>" placeholder="Enter question">
							<?php if($errors->has('question')): ?>
								<p class="help text-danger"><?php echo e($errors->first('question')); ?></p>
							<?php endif; ?>
						</div>

						<div class="form-group col-12">
							<label class="text-capitalize" for="answer">answer</label>
							<input type="text" class="form-control" name="answer" id="answer" required value="<?php echo e(isset($faq) ? $faq->answer : old('answer')); ?>" placeholder="Enter answer">
							<?php if($errors->has('answer')): ?>
								<p class="help text-danger"><?php echo e($errors->first('answer')); ?></p>
							<?php endif; ?>
						</div>

						<div class="form-group col-12">
							<label class="text-capitalize" for="sort_order">sort order</label>
							<input type="number" class="form-control" name="sort_order" id="sort_order" required value="<?php echo e(isset($faq) ? $faq->sort_order : old('sort_order')); ?>" placeholder="Enter sort_order">
							<?php if($errors->has('sort_order')): ?>
								<p class="help text-danger"><?php echo e($errors->first('sort_order')); ?></p>
							<?php endif; ?>
						</div>

						<div class="form-group col-12 mt-2 mb-4">
							<div class="checkbox">
								<div class="custom-checkbox custom-control">
									<?php isset($faq) ? $featured = $faq->featured : $featured = 0; ?>
									<input type="checkbox" data-checkboxes="mygroup" name="featured" value="1" <?php echo e($featured ? 'checked' : ''); ?> class="custom-control-input" id="featured">
									<label for="featured" class="custom-control-label mt-1"> Is featured?</label>
								</div>
							</div>
						</div>



						<div class="form-group col-12 mb-0 mt-3 justify-content-end">
							<div>
								<button type="submit" class="btn btn-primary"><?php echo e(isset($faq) ? 'Update': 'Create'); ?></button>
							</div>
						</div>
					</form>
				</div>
			</div>
		</div>
		<!-- faq form END -->

	</div>
	<!-- row -->

</div>
<!-- Container closed -->
</div>
<!-- main-content closed -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<!--Internal Fileuploads js-->
<script src="<?php echo e(URL::asset('assets/plugins/fileuploads/js/fileupload.js')); ?>"></script>
<script src="<?php echo e(URL::asset('assets/plugins/fileuploads/js/file-upload.js')); ?>"></script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/cosmeticbox/public_html/lavie-admin/resources/views/faqs/form.blade.php ENDPATH**/ ?>