
<?php $__env->startSection('title', 'Customers'); ?>

<?php $__env->startSection('page-header'); ?>
	<!-- breadcrumb -->
	<div class="breadcrumb-header justify-content-between">
		<div class="my-auto">
			<div class="d-flex">
				<h4 class="content-title mb-0 my-auto">Dashboard</h4><span class="text-muted mt-1 tx-13 mr-2 mb-0">/ Customers</span>
			</div>
		</div>
	</div>
	<!-- breadcrumb -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

		<div class="loader-container hidden">
			<div class="spinner-bcustomer"></div>
		</div>

		<!-- row opened -->
		<div class="row row-sm">

			<div class="col-xl-12">
				<div class="card">
					<div class="card-header pb-0">
						<div class="d-flex justify-content-between">
							<h4 class="card-title mg-b-0">Customers TABLE</h4>
							<i class="mdi mdi-dots-horizontal text-gray"></i>
						</div>
					</div>
					<div class="card-body">

						<!-- Start Filter -->
						<div class="filter-box mb-5">
							<form action="<?php echo e(route('customers.index', ['page'=>1])); ?>" method="GET">

								<input type="hidden" name="page" value="1">
								<input type="hidden" name="filter" value="1">
					
								<div class="row bg-white pt-4">
									<div class="col-6 col-lg-3">
										<div class="form-group">
											<input type="number" class="form-control" name="phone" placeholder="Phone">
										</div>
									</div>
									<div class="col-6 col-lg-3">
										<div class="form-group">
											<input type="text" class="form-control" name="fullname" placeholder="Name">
										</div>
									</div>
									<div class="col-6 col-lg-3">
										<div class="form-group">
											<input type="text" class="form-control date" name="created_at" placeholder="Registiration Date">
										</div>
									</div>
									<div class="col-6 col-lg-3">
										<div class="form-group">
											<button type="submit" class="btn btn-danger" style="width: 100%"><i class="fa-solid fa-magnifying-glass"></i> Filter</button>
										</div>
									</div>
								</div>
						
							</form>
						</div>
						<!-- End Filter -->

						<!-- Start Table -->
						<div class="table-responsive">
							<table class="table text-md-nowrap" id="example1">
								<thead>
									<tr>
										<th class="all">Id</th>
										<th class="all">Name</th>
										<th class="all">Email</th>
										<th class="all">Status</th>
										<th class="all">Registration date</th>
										<th class="all">Action</th>
									</tr>
								</thead>
								<tbody>
									<?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
									<tr>
										<input type="hidden" class="deleted_id" value="<?php echo e($customer->id_customer); ?>">
										<td><?php echo e($customer->id_customer); ?></td>
										<td><?php echo e($customer->fullname); ?></td>
										<td><?php echo e($customer->email); ?></td>
										<?php if($customer->active == 1): ?>
										<td>Active <i class="fa-solid fa-lightbulb ml-2 text-success"></i></td>
										<?php elseif($customer->active == 2): ?>
										<td>Blocked <i class="fa fa-lightbulb ml-2 text-danger"></i></td>
										<?php else: ?>
										<td>Inactive <i class="fa fa-lightbulb ml-2 text-danger"></i></td>
										<?php endif; ?>
										<td><?php echo e(date("d M Y", strtotime($customer->date_add))); ?></td>
										<td>
											<a href="customers/<?php echo e($customer->id_customer); ?>"><i class="fa-solid fa-pen-to-square"></i></a>
										</td>
									</tr>
									<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
								</tbody>
							</table>
						</div>
						<!-- End Table -->



						<!-- Start Pagination -->
						<?php if(count($customers) > 0): ?>
		
						<div class="text-center text-md-left font-size-14 mb-3 text-lh-1">Page <?php echo e($page); ?>–<?php echo e($num_of_pages); ?></div>
						<nav aria-label="Page navigation" id="pagiantionNav">
							<ul class="list-pagination-1 pagination bcustomer bcustomer-color-4 rounded-sm mb-5 mb-lg-0 overflow-auto overflow-xl-visible justify-content-md-center align-items-center py-2">
								
								<li class="page-item <?php echo e($page==1 ? 'disabled' : ''); ?>">
									<a class="page-link bg-none  rounded-0 text-dark" href="#" data-page="1" aria-label="Previous" title="Start">
										<i class="fa-solid fa-angles-left"></i>
									</a>
								</li>
								<li class="page-item <?php echo e($page==1 ? 'disabled' : ''); ?>">
									<a class="page-link bg-none  rounded-0 text-dark" href="#" data-page="<?php echo e($page-1); ?>" aria-label="Previous">
										<i class="fa-solid fa-angle-left" title="Previous"></i>
									</a>
								</li>
		
								<?php
									if($page < 11) {
										$pagination_start = 1;
									} else {
										$pagination_start = ((int) ($page / 10)) * 10;
									}
								?>
		
								<?php for($page_count = $pagination_start, $i=1; $page_count <= $num_of_pages; $page_count++, $i++): ?>
		
								<?php if ($i>10) { break;} ?>
		
								<li class="page-item <?php echo e($page==$page_count ? 'active disabled-link' : ''); ?>">
									<a class="page-link font-size-14 text-dark <?php echo e($page==$page_count ? 'text-white' : ''); ?>" href="#" data-page="<?php echo e($page_count); ?>"><?php echo e($page_count); ?></a>
								</li>
								
								<?php endfor; ?>
		
								<li class="page-item <?php echo e($page==$num_of_pages ? 'disabled' : ''); ?>">
									<a class="page-link bg-none  rounded-0 text-dark" href="#" data-page="<?php echo e($page+1); ?>" aria-label="Next">
										<i class="fa-solid fa-angle-right" title="Next"></i>
									</a>
								</li>
								<li class="page-item <?php echo e($page==$num_of_pages ? 'disabled' : ''); ?>">
									<a class="page-link bg-none  rounded-0 text-dark" href="#" data-page="<?php echo e($num_of_pages); ?>" aria-label="Next" title="End">
										<i class="fa-solid fa-angles-right"></i>
									</a>
								</li>
								
							</ul>
						</nav>
		
						<?php endif; ?>
						<!-- End Pagination -->


					</div>
				</div>
			</div>
			<!--/div-->
		</div>
		<!-- /row -->
	</div>
	<!-- Container closed -->
</div>
<!-- main-content closed -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>

<script>

	function pagination($this) {
		var page = $this.data('page');

		var params = new URLSearchParams(location.search);
		params.set('page', page);
		window.location.search = params.toString();

	}
	

	$(document).ready(function() {

		// *** Pagination
		$('#pagiantionNav .page-link').on('click', function(e) {
			e.preventDefault();
			pagination($(this));
		});

		$("input.date").focus(function() {
			$(this).attr("type", "date");
		});
		
	});



</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/marketscene/public_html/fitnasyum_admin/resources/views/customers/index.blade.php ENDPATH**/ ?>