<?php if(isset($lectures)): ?>
<?php $__currentLoopData = $lectures; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lecture): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<!-- Course Lectures forms start -->
<div class="col-sm-12">
    <div class="card pt-0 box-shadow-0">
        <div class="card-header">
            <h4>Edit Lecture <?php echo e($lecture->sort_order); ?></h4>
        </div>
        <div class="card-body pt-0">
            <form class="form-horizontal row" method="POST" action="<?php echo e(isset($lecture) ? Route('lectures.update', ['lecture'=>$lecture->id]) : Route('lectures.store')); ?>" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="course_id" value="<?php echo e($lecture->course_id); ?>">
                <div class="form-group col-8">
                    <label class="text-capitalize" for="title">title</label>
                    <input type="text" class="form-control" name="title" id="title" required value="<?php echo e(isset($lecture) ? $lecture->title : old('title')); ?>" placeholder="Enter title">
                    <?php if($errors->has('title')): ?>
                        <p class="help text-danger"><?php echo e($errors->first('title')); ?></p>
                    <?php endif; ?>
                </div>

                <div class="form-group col-4">
                    <label class="text-capitalize" for="sort_order">Sort order</label>
                    <input type="number" class="form-control" name="sort_order" id="sort_order" required value="<?php echo e(isset($lecture) ? $lecture->sort_order : old('sort_order')); ?>" placeholder="Enter sort order">
                    <?php if($errors->has('sort_order')): ?>
                        <p class="help text-danger"><?php echo e($errors->first('sort_order')); ?></p>
                    <?php endif; ?>
                </div>

                <!-- Thumbnail Upload -->
                <div class="col-12">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="card">

                                <div class="card-body">
                                    <div>
                                        <h6 class="card-title mb-1">Thumbnail Upload</h6>
                                    </div>
                                    <div class="row mb-4">
                                        <?php if(isset($lecture)): ?>
                                        <div class="col-lg-4 col-md-12 mb-4 mb-lg-0">
                                            <img
                                                src=" <?php echo e(asset('uploads/lectures/'.$lecture->thumbnail)); ?>"
                                                class="w-100 shadow-1-strong rounded mb-4 img-fluid"
                                                alt="<?php echo e($lecture->title); ?>"
                                                style="max-height: 210px; min-height: 210px;"
                                            />
                                        </div>
                                        <?php endif; ?>
                                        <div class="col-sm-12 col-md-4">
                                            <input type="file" name="thumbnail" class="dropify" data-height="200" />
                                        </div>
                                    </div>
                                </div>
                                <?php if($errors->has('thumbnail')): ?>
                                    <p class="help text-danger"><?php echo e($errors->first('thumbnail')); ?></p>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Thumbnail Upload closed -->

                <!-- video Upload -->
                <div class="col-12">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-body">
                                    <div>
                                        <h6 class="card-title mb-1">Video Upload</h6>
                                    </div>
                                    <div class="row mb-4">
                                        <?php if(isset($lecture) && $lecture->video_src): ?>
                                        <div class="col-lg-4 col-md-12 mb-4 mb-lg-0">
                                            <video controls class="w-100 shadow-1-strong rounded mb-4" style="max-height: 210px; min-height: 210px;">
                                                <source src="<?php echo e(asset('uploads/lectures_videos/' . $lecture->video_src)); ?>" type="video/mp4">
                                                <!-- You can add additional source elements for different video formats here if needed -->
                                                Your browser does not support the video tag.
                                            </video>
                                        </div>
                                        <?php endif; ?>
                                        <div class="col-sm-12 col-md-4">
                                            <input type="file" name="video_src" accept="video/*" class="dropify" data-height="200" />
                                        </div>
                                    </div>
                                </div>
                                <?php if($errors->has('video_src')): ?>
                                <p class="help text-danger"><?php echo e($errors->first('video_src')); ?></p>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- video Upload closed -->


                <div class="form-group col-12 mb-0 mt-3 justify-content-end">
                    <div>
                        <button type="submit" class="btn btn-primary"><?php echo e(isset($lecture) ? 'Update': 'Create'); ?></button>
                        <a href="#" class="btn btn-danger delete-record" data-record-id="<?php echo e($lecture->id); ?>">Delete</a>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
<!-- Course Lectures forms END -->
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php endif; ?>
<?php /**PATH E:\xampp\htdocs\digital-dentistry-admin\resources\views/courses/fetch-lecs-by-ajax.blade.php ENDPATH**/ ?>