
<?php $__env->startSection('title'); ?>
	<?php echo e(isset($property) ? 'Edit property': 'Add property'); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('css'); ?>
<!---Internal Fileupload css-->
<link href="<?php echo e(URL::asset('assets/plugins/fileuploads/css/fileupload.css')); ?>" rel="stylesheet" type="text/css"/>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('page-header'); ?>
	<!-- breadcrumb -->
	<div class="breadcrumb-header justify-content-between">
		<div class="my-auto">
			<div class="d-flex">
				<h4 class="content-title mb-0 my-auto">property</h4><span class="text-muted mt-1 tx-13 mr-2 mb-0">/ <?php echo e(isset($property) ? 'Edit': 'Create'); ?></span>
			</div>
		</div>
	</div>
	<!-- breadcrumb -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
	<!-- row -->
	<div class="row row-sm">

		<!-- property form start -->
		<div class="col-sm-12">
			<div class="card pt-4 box-shadow-0">
				<div class="card-body pt-0">
					<form class="form-horizontal row" method="POST" action="<?php echo e(isset($property) ? Route('properties.update', ['property'=>$property->id]) : Route('properties.store')); ?>" enctype="multipart/form-data">
						<?php echo csrf_field(); ?>
						<div class="form-group col-12">
							<label class="text-capitalize" for="title">title</label>
							<input type="text" class="form-control" name="title" id="title" required value="<?php echo e(isset($property) ? $property->title : old('title')); ?>" placeholder="Enter title">
							<?php if($errors->has('title')): ?>
								<p class="help text-danger"><?php echo e($errors->first('title')); ?></p>
							<?php endif; ?>
						</div>

						<div class="form-group col-12">
							<label class="text-capitalize" for="slug">property slug</label>
							<?php if(!isset($property)): ?>
							<label> - (Permlink: https://wallstreet-elite.com/ar/property/new-property)</label>
							<?php endif; ?>
							<input type="text" class="form-control" name="slug" id="slug" required value="<?php echo e(isset($property) ? $property->slug : old('slug')); ?>" placeholder="Ex: new-property">
							<?php if($errors->has('slug')): ?>
								<p class="help text-danger"><?php echo e($errors->first('slug')); ?></p>
							<?php endif; ?>
						</div>


						<div class="form-group col-6">
							<label class="text-capitalize" for="original_price">original price</label>
							<input type="number" class="form-control" name="original_price" id="original_price" required value="<?php echo e(isset($property) ? $property->original_price : old('original_price')); ?>" placeholder="Enter original price">
							<?php if($errors->has('original_price')): ?>
								<p class="help text-danger"><?php echo e($errors->first('original_price')); ?></p>
							<?php endif; ?>
						</div>

						<div class="form-group col-6">
							<label class="text-capitalize" for="sell_price">sell price</label>
							<input type="number" class="form-control" name="sell_price" id="sell_price" required value="<?php echo e(isset($property) ? $property->sell_price : old('sell_price')); ?>" placeholder="Enter sell price">
							<?php if($errors->has('sell_price')): ?>
								<p class="help text-danger"><?php echo e($errors->first('sell_price')); ?></p>
							<?php endif; ?>
						</div>


						<div class="form-group col-12">
							<label class="text-capitalize" for="description">description</label>
							<textarea class="description" name="description" rows="8"><?php echo e(isset($property) ? $property->description : old('description')); ?></textarea>
							<?php if($errors->has('description')): ?>
								<p class="help text-danger"><?php echo e($errors->first('description')); ?></p>
							<?php endif; ?>
						</div>

						<div class="form-group col-6">
							<label class="text-capitalize" for="location">location</label>
							<input type="text" class="form-control" name="location" id="location" required value="<?php echo e(isset($property) ? $property->location : old('location')); ?>" placeholder="Enter location">
							<?php if($errors->has('location')): ?>
								<p class="help text-danger"><?php echo e($errors->first('location')); ?></p>
							<?php endif; ?>
						</div>

						<div class="form-group col-6">
							<label class="text-capitalize" for="area_id">area</label>
							<?php isset($property) ? $area_id = $property->area_id : $area_id = '';  ?>
							<select name="area_id" id="area_id" class="form-control" required>
								<option value="" selected disabled>Choose Area</option>
								<?php $__currentLoopData = $areas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $area): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
								<option value="<?php echo e($area->id); ?>" <?php echo e($area->id == $area_id ? 'selected' : ''); ?>><?php echo e($area->name); ?></option>
								<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
							</select>
							<?php if($errors->has('area_id')): ?>
								<p class="help text-danger"><?php echo e($errors->first('area_id')); ?></p>
							<?php endif; ?>
						</div>

						<div class="form-group col-4">
							<label class="text-capitalize" for="baths">baths</label>
							<input type="number" class="form-control" name="baths" id="baths" required value="<?php echo e(isset($property) ? $property->baths : old('baths')); ?>" placeholder="Enter baths">
							<?php if($errors->has('baths')): ?>
								<p class="help text-danger"><?php echo e($errors->first('baths')); ?></p>
							<?php endif; ?>
						</div>

						<div class="form-group col-4">
							<label class="text-capitalize" for="rooms">rooms</label>
							<input type="number" class="form-control" name="rooms" id="rooms" required value="<?php echo e(isset($property) ? $property->rooms : old('rooms')); ?>" placeholder="Enter rooms">
							<?php if($errors->has('rooms')): ?>
								<p class="help text-danger"><?php echo e($errors->first('rooms')); ?></p>
							<?php endif; ?>
						</div>

						<div class="form-group col-4">
							<label class="text-capitalize" for="area">area (m2)</label>
							<input type="number" class="form-control" name="area" id="area" required value="<?php echo e(isset($property) ? $property->area : old('area')); ?>" placeholder="Enter area">
							<?php if($errors->has('area')): ?>
								<p class="help text-danger"><?php echo e($errors->first('area')); ?></p>
							<?php endif; ?>
						</div>

						<div class="form-group col-12 mt-2 mb-4">
							<div class="checkbox">
								<div class="custom-checkbox custom-control">
									<?php isset($property) ? $featured = $property->featured : $featured = 0; ?>
									<input type="checkbox" data-checkboxes="mygroup" name="featured" value="1" <?php echo e($featured ? 'checked' : ''); ?> class="custom-control-input" id="featured">
									<label for="featured" class="custom-control-label mt-1"> Is featured?</label>
								</div>
							</div>
						</div>

						<!-- img Upload -->
						<div class="col-12">
							<div class="row">
								<div class="col-md-12">
									<div class="card">

										<div class="card-body">
											<div>
												<h6 class="card-title mb-1">image Upload</h6>
											</div>
											<div class="row mb-4">
												<div class="col-sm-12 col-md-4">
													<input type="file" name="img" class="dropify" data-height="200" />
												</div>
												<?php if(isset($property)): ?>
												<div class="col-lg-4 col-md-12 mb-4 mb-lg-0">
													<img
														src="<?php echo e(asset('uploads/properties/'.$property->img)); ?>"
														class="w-100 shadow-1-strong rounded mb-4 img-fluid"
														alt="<?php echo e($property->title); ?>"
														style="max-height: 210px; min-height: 210px;"
													/>
												</div>
												<?php endif; ?>
											</div>
										</div>
										<?php if($errors->has('img')): ?>
											<p class="help text-danger"><?php echo e($errors->first('img')); ?></p>
										<?php endif; ?>
									</div>
								</div>
							</div>
						</div>
						<!-- img Upload closed -->

						<!-- gallery Upload -->
						<div class="col-12">
							<div class="row">
								<div class="col-md-12">
									<div class="card">

										<div class="card-body">
											<div>
												<h6 class="card-title mb-1">gallery Upload</h6>
											</div>
											<div class="row mb-4">
												<div class="col-sm-12 col-md-4">
													<input type="file" name="gallery[]" class="dropify" multiple="multiple" data-height="200" />
												</div>

												<!-- Gallery IMGS -->
												<?php if(isset($property->gallery)): ?>
											
												<?php $images = explode(', ', $property->gallery); ?>
							
													<?php $__currentLoopData = $images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
													<?php if($image == null): ?>
														<?php continue; ?>
													<?php endif; ?>
													<div class="col-sm-12 col-md-4 mb-4 mb-lg-0">
														<img
															src="<?php echo e(asset('/uploads/properties/'.$image)); ?>"
															class="w-100 shadow-1-strong rounded mb-4 img-fluid"
															alt="<?php echo e($property->title); ?> img"
															style="max-height: 210px; min-height: 210px;"
														/>
													</div>
													<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
							
												<?php endif; ?>
												<!-- Gallery IMGS END -->
												
											</div>
										</div>
										<?php if($errors->has('gallery')): ?>
											<p class="help text-danger"><?php echo e($errors->first('gallery')); ?></p>
										<?php endif; ?>

										<?php for($i = 0; $i < 15; $i++): ?>
										<?php if($errors->has('gallery.' . $i)): ?>
											<p class="help text-danger">IMG Num(<?php echo e($i); ?>) - <?php echo e($errors->first('gallery.' . $i)); ?></p>
										<?php endif; ?>
										<?php endfor; ?>

									</div>
								</div>
							</div>
						</div>
						<!-- gallery Upload closed -->


						<div class="form-group col-12 mb-0 mt-3 justify-content-end">
							<div>
								<button type="submit" class="btn btn-primary"><?php echo e(isset($property) ? 'Update': 'Create'); ?></button>
							</div>
						</div>
					</form>
				</div>
			</div>
		</div>
		<!-- property form END -->

	</div>
	<!-- row -->

</div>
<!-- Container closed -->
</div>
<!-- main-content closed -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<!--Internal Fileuploads js-->
<script src="<?php echo e(URL::asset('assets/plugins/fileuploads/js/fileupload.js')); ?>"></script>
<script src="<?php echo e(URL::asset('assets/plugins/fileuploads/js/file-upload.js')); ?>"></script>
<!--tinymce js-->
<script src="https://cdn.tiny.cloud/1/z11c2h50n7nrfmryazjs4xzib8487mkjns9jlwpqns4wd715/tinymce/6/tinymce.min.js" referrerpolicy="origin"></script>

<script>

	// tinymce

	tinymce.init({
        selector: '.description',
        height : '400',
		plugins: 'anchor autolink charmap codesample emoticons image link lists media searchreplace table visualblocks wordcount',
      	toolbar: 'undo redo | blocks fontfamily fontsize | bold italic underline strikethrough | link image media table | align lineheight | numlist bullist indent outdent | emoticons charmap | removeformat',
		font_size_formats: '8px 10px 12px 14px 16px 17px 18px 20px 22px 24px 28px 32px 36px 40px 48px 56px 64px',
		content_style: "body { direction: rtl; text-align: right; }",
    });

</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp\htdocs\wallstreet-elite-admin\resources\views/properties/form.blade.php ENDPATH**/ ?>