
<?php $__env->startSection('title'); ?>
	<?php echo e(isset($clinic) ? 'Edit clinic': 'Add clinic'); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('css'); ?>
<!-- Internal Select2 css -->
<link href="<?php echo e(URL::asset('assets/plugins/select2/css/select2.min.css')); ?>" rel="stylesheet">
<!--Internal  Datetimepicker-slider css -->
<link href="<?php echo e(URL::asset('assets/plugins/amazeui-datetimepicker/css/amazeui.datetimepicker.css')); ?>" rel="stylesheet">
<link href="<?php echo e(URL::asset('assets/plugins/jquery-simple-datetimepicker/jquery.simple-dtpicker.css')); ?>" rel="stylesheet">
<link href="<?php echo e(URL::asset('assets/plugins/pickerjs/picker.min.css')); ?>" rel="stylesheet">
<!---Internal Fileupload css-->
<link href="<?php echo e(URL::asset('assets/plugins/fileuploads/css/fileupload.css')); ?>" rel="stylesheet" type="text/css"/>

<!-- Internal Spectrum-colorpicker css -->
<link href="<?php echo e(URL::asset('assets/plugins/spectrum-colorpicker/spectrum.css')); ?>" rel="stylesheet">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('page-header'); ?>
	<!-- breadcrumb -->
	<div class="breadcrumb-header justify-content-between">
		<div class="my-auto">
			<div class="d-flex">
				<h4 class="content-title mb-0 my-auto">clinic</h4>
				<span class="text-muted mt-1 tx-13 mr-2 mb-0">/ <?php echo e(isset($clinic) ? 'Edit': 'Create'); ?></span>
			</div>
			<?php if(isset($doctors)): ?>
			<div class="d-flex">
				<h4 class="content-title mt-3 tx-16">(<?php echo e(count($doctors)); ?>) <span class="text-primary">Doctors Registered</span></h4>
			</div>		
			<?php endif; ?>	
		</div>
	</div>
	<!-- breadcrumb -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
	<!-- row -->
	<div class="row row-sm">

		
		<div class="col-sm-12">
			<div class="card pt-4 box-shadow-0">
				<div class="card-body pt-0">
					<form class="form-horizontal row" method="POST" action="<?php echo e(isset($clinic) ? Route('clinics.update', ['clinic'=>$clinic->id]) : Route('clinics.store')); ?>" enctype="multipart/form-data">
						<?php echo csrf_field(); ?>
						<div class="form-group col-6">
							<label class="text-capitalize" for="name">Clinic name</label>
							<input type="text" class="form-control" name="name" id="name" required value="<?php echo e(isset($clinic) ? $clinic->name : old('name')); ?>" placeholder="Enter Clinic name">
							<?php if($errors->has('name')): ?>
								<p class="help text-danger"><?php echo e($errors->first('name')); ?></p>
							<?php endif; ?>
						</div>
						<div class="form-group col-6">
							<label class="text-capitalize" for="name_ar">Clinic arabic name</label>
							<input type="text" class="form-control" name="name_ar" id="name_ar" required value="<?php echo e(isset($clinic) ? $clinic->name_ar : old('name_ar')); ?>" placeholder="Enter Clinic arabic name">
							<?php if($errors->has('name_ar')): ?>
								<p class="help text-danger"><?php echo e($errors->first('name_ar')); ?></p>
							<?php endif; ?>
						</div>
						
						<!--Insurance-->
						<div class="col-12 mt-4">
							<div class="table-responsive">
								<table class="table table-bordered table-addRmeove">
									<thead>
										<tr>
											<th class="text-capitalize font-size-13">insurance companies</th>
											<th class="text-capitalize font-size-13">action</th>
										</tr>
									</thead>
									<tbody id="tbody_insurance" class="tbody">
										<?php if(isset($clinic)): ?> 
										<?php $i=0;  ?>
										<?php $__currentLoopData = json_decode($clinic->insurance); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $insurance): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
										<tr id="R_<?php echo e($i); ?>" data-counter="<?php echo e($i); ?>">
											<td class="row-index" width="80%">
												<div class="form-group">
													<input type="text" class="form-control non-required" name="insurance[<?php echo e($i); ?>]" value="<?php echo e($insurance->company); ?>" placeholder="Enter Company Name">
												</div>
											</td>
											<td width="20%">
												<button class="btn remove" type="button"><i class="fa-solid fa-minus text-danger"></i></button>
												<button class="btn addBtn" type="button"><i class="fa-solid fa-plus text-primary"></i></button>
											</td>
										</tr>
										<?php $i++;  ?>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
										
										<?php else: ?>
										<tr id="R_0" data-counter="0">
											<td class="row-index" width="80%">
												<div class="form-group">
													<input type="text" class="form-control non-required" name="insurance[0]" placeholder="Enter Company Name">
												</div>
											</td>
											<td width="20%">
												<button class="btn remove" type="button"><i class="fa-solid fa-minus text-danger"></i></button>
												<button class="btn addBtn" type="button"><i class="fa-solid fa-plus text-primary"></i></button>
											</td>
										</tr>
										<?php endif; ?>
									</tbody>
								</table>
							</div>
						</div>
						<!--End Insurance-->
						
						<div class="form-group col-6">
							<label class="text-capitalize" for="phone">phone</label>
							<input type="number" class="form-control" name="phone" id="phone" required value="<?php echo e(isset($clinic) ? $clinic->phone : old('phone')); ?>" placeholder="Enter phone">
							<?php if($errors->has('phone')): ?>
								<p class="help text-danger"><?php echo e($errors->first('phone')); ?></p>
							<?php endif; ?>
						</div>
						
						<div class="form-group col-6">
							<label class="text-capitalize" for="address">address</label>
							<input type="text" class="form-control" name="address" id="address" required value="<?php echo e(isset($clinic) ? $clinic->address : old('address')); ?>" placeholder="Enter Clinic address">
							<?php if($errors->has('address')): ?>
								<p class="help text-danger"><?php echo e($errors->first('address')); ?></p>
							<?php endif; ?>
						</div>
						<div class="form-group col-12">
							<label class="text-capitalize" for="address_ar">arabic address</label>
							<input type="text" class="form-control" name="address_ar" id="address_ar" required value="<?php echo e(isset($clinic) ? $clinic->address_ar : old('address_ar')); ?>" placeholder="Enter Clinic arabic address">
							<?php if($errors->has('address_ar')): ?>
								<p class="help text-danger"><?php echo e($errors->first('address_ar')); ?></p>
							<?php endif; ?>
						</div>
					
						<div class="form-group col-6">
							<label class="text-capitalize" for="brief">brief</label>
							<textarea class="form-control" rows="3" name="brief" id="brief" placeholder="Enter Clinic Brief"><?php echo e(isset($clinic) ? $clinic->brief : old('brief')); ?></textarea>
							<?php if($errors->has('brief')): ?>
								<p class="help text-danger"><?php echo e($errors->first('brief')); ?></p>
							<?php endif; ?>
						</div>

						<div class="form-group col-6">
							<label class="text-capitalize" for="brief_ar">arabic brief</label>
							<textarea class="form-control" rows="3" name="brief_ar" id="brief_ar" placeholder="Enter arabic Brief"><?php echo e(isset($clinic) ? $clinic->brief_ar : old('brief_ar')); ?></textarea>
							<?php if($errors->has('brief_ar')): ?>
								<p class="help text-danger"><?php echo e($errors->first('brief_ar')); ?></p>
							<?php endif; ?>
						</div>


						<!-- Image Upload -->
						<div class="col-12">
							<div class="row">
								<div class="col-md-12">
									<div class="card">
										<div class="card-body">
											<div>
												<h6 class="card-title mb-1">Images Upload</h6>
											</div>
											<div class="row mb-4">
												<div class="col-sm-12 col-md-4">
													<input type="file" name="imgs[]" multiple class="dropify" data-height="200" />
												</div>
											</div>
										</div>
										<?php if($errors->has('imgs.*')): ?>
											<p class="help text-danger"><?php echo e($errors->first('imgs.*')); ?></p>
										<?php endif; ?>

									</div>
								</div>
							</div>

							<div class="row">
								<?php if(isset($clinic->imgs)): ?>
								
								<?php $images = explode(', ', $clinic->imgs); ?>
		
								<?php $__currentLoopData = $images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
								<?php if($image == null): ?>
									<?php continue; ?>
								<?php endif; ?>
								<div class="col-lg-4 col-md-12 mb-4 mb-lg-0">
									<img
										src="<?php echo e(asset('/uploads/clinics/'.$image)); ?>"
										class="w-100 shadow-1-strong rounded mb-4 img-fluid"
										alt="<?php echo e($clinic->title); ?>"
										style="max-height: 280px; min-height: 280px;"
									/>
								</div>
								<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
								
								<?php endif; ?>
							</div>
						</div>
						<!-- Image Upload closed -->

						<div class="form-group col-12">
							<div class="checkbox">
								<div class="custom-checkbox custom-control">
									<?php if(isset($clinic)): ?>
									<input type="checkbox" data-checkboxes="mygroup" name="premium" value="true" <?php echo e($clinic->premium == 'true' ? 'checked' : ''); ?> class="custom-control-input" id="premium">
									<?php else: ?>
									<input type="checkbox" data-checkboxes="mygroup" name="premium" value="true" class="custom-control-input" id="premium">
									<?php endif; ?>
									<label for="premium" class="custom-control-label mt-1"> Premium ?</label>
								</div>
							</div>
						</div>

						<div class="form-group col-12 mb-0 mt-3 justify-content-end">
							<div>
								<button type="submit" class="btn btn-primary"><?php echo e(isset($clinic) ? 'Update': 'Create'); ?></button>
							</div>
						</div>
					</form>
				</div>
			</div>
		</div>

		<?php if(isset($doctors) && count($doctors) > 0): ?>
		
		<div class="col-xl-12">
			<div class="card">
				<div class="card-header pb-0">
					<div class="d-flex justify-content-between">
						<h4 class="card-title mg-b-0">Registered Doctors TABLE <span class="text-primary mt-1 tx-13 ml-1 mb-0">(<?php echo e(count($doctors)); ?>) Doctors</span></h4>
						<i class="mdi mdi-dots-horizontal text-gray"></i>
					</div>
				</div>
				<div class="card-body">
					<div class="table-responsive">
						<table class="table text-md-nowrap" id="example1">
							<thead>
								<tr>
									<th class="all border-bottom-0">#</th>
									<th class="all border-bottom-0">Name</th>
									<th class="all border-bottom-0">Specialty</th>
									<th class="all border-bottom-0">Sub Specialty</th>
									<th class="all border-bottom-0">Governorate</th>
									<th class="all border-bottom-0">Cost</th>
									<th class="all border-bottom-0">Type</th>
									<th class="all border-bottom-0">Action</th>
								</tr>
							</thead>
							<tbody>
								<?php $__currentLoopData = $doctors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $doctor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
								<tr>
									<td><?php echo e($doctor->id); ?></td>
									<td><?php echo e($doctor->name); ?></td>
									<td><?php echo e($doctor->specialty); ?></td>
									<td><?php echo e($doctor->sub_specialties); ?></td>
									<td><?php echo e(isset($doctor->governorate) ? $doctor->governorate->governorate_name_en : 'Undefined'); ?></td>
									<td><?php echo e($doctor->cost); ?></td>
									<td><?php echo e($doctor->type); ?></td>
									<td>
										<a href="<?php echo e(url('/admin/doctors/'.$doctor->id)); ?>" class="mr-3"><i class="fa-solid fa-pen-to-square"></i></a>
										<a href="<?php echo e(url('/admin/clinics/unattach_doctor/'.$doctor->id)); ?>"><i class="fa-solid fa-trash" title="Remove Doctor"></i></a>
									</td>
								</tr>
								<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
							</tbody>
						</table>
					</div>
				</div>
			</div>
		</div>
		<?php endif; ?>

	</div>
	<!-- row -->

</div>
<!-- Container closed -->
</div>
<!-- main-content closed -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<!--Internal  Datepicker js -->
<script src="<?php echo e(URL::asset('assets/plugins/jquery-ui/ui/widgets/datepicker.js')); ?>"></script>
<!--Internal Fileuploads js-->
<script src="<?php echo e(URL::asset('assets/plugins/fileuploads/js/fileupload.js')); ?>"></script>
<script src="<?php echo e(URL::asset('assets/plugins/fileuploads/js/file-upload.js')); ?>"></script>

<!--Internal dynamicrows js-->
<script src="<?php echo e(URL::asset('assets/js/dynamicrows.js')); ?>"></script>

<!--Internal  jquery.maskedinput js -->
<script src="<?php echo e(URL::asset('assets/plugins/jquery.maskedinput/jquery.maskedinput.js')); ?>"></script>
<!--Internal  spectrum-colorpicker js -->
<script src="<?php echo e(URL::asset('assets/plugins/spectrum-colorpicker/spectrum.js')); ?>"></script>
<!-- Internal Select2.min js -->
<script src="<?php echo e(URL::asset('assets/plugins/select2/js/select2.min.js')); ?>"></script>
<!--Internal Ion.rangeSlider.min js -->
<script src="<?php echo e(URL::asset('assets/plugins/ion-rangeslider/js/ion.rangeSlider.min.js')); ?>"></script>
<!--Internal  jquery-simple-datetimepicker js -->
<script src="<?php echo e(URL::asset('assets/plugins/amazeui-datetimepicker/js/amazeui.datetimepicker.min.js')); ?>"></script>
<!-- Ionicons js -->
<script src="<?php echo e(URL::asset('assets/plugins/jquery-simple-datetimepicker/jquery.simple-dtpicker.js')); ?>"></script>
<!--Internal  pickerjs js -->
<script src="<?php echo e(URL::asset('assets/plugins/pickerjs/picker.min.js')); ?>"></script>
<!-- Internal form-elements js -->
<script src="<?php echo e(URL::asset('assets/js/form-elements.js')); ?>"></script>

<script>
    $(document).ready(function () {

		// ******** Start Insurance ********

		// Denotes total number of rows
		var rowIdx;
		// jQuery button click event to add a row
		$('#tbody_insurance').on('click', '.addBtn', function () {

			rowIdx = $(this).parents('tbody').find("tr").last().data('counter');

			// Adding a row inside the tbody.
			$('#tbody_insurance').append(`
			<tr id="R_${++rowIdx}" data-counter="${rowIdx}">
				<td class="row-index" width="70%">
					<div class="form-group">
						<input type="text" class="form-control non-required" name="insurance[${rowIdx}]" placeholder="Enter Company Name">
					</div>
				</td>
				<td width="30%">
					<button class="btn remove" type="button"><i class="fa-solid fa-minus text-danger"></i></button>
					<button class="btn addBtn" type="button"><i class="fa-solid fa-plus text-primary"></i></button>
				</td>
			</tr>`);

			$('input.non-required').prop("required", false);
		});

      	// jQuery button click event to remove a row.
		$('#tbody_insurance').on('click', '.remove', function () {

			// Check If Is There Only One Row
			if($(this).parents('tbody').find("tr").length == 1) {

			} else {

				// Getting all the rows next to the row
				// containing the clicked button
				var child = $(this).closest('tr').nextAll();

				// Iterating across all the rows 
				// obtained to change the index
				child.each(function () {

					// Getting <tr> id.
					var id = $(this).attr('id');

					// Getting the <p> inside the .row-index class.
					var idx = $(this).children('.row-index').children('p');

					// Gets the row number from <tr> id.
					var dig = parseInt(id.substring(1));

					// Modifying row index.
					idx.html(`Row ${dig - 1}`);

					// Modifying row id.
					$(this).attr('id', `R_${dig - 1}`);
				});

				// Removing the current row.
				$(this).closest('tr').remove();

				// Decreasing total number of rows by 1.
				rowIdx--;

			}
		});

		

		// ******** End Insurance ********


    });
  </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp\htdocs\moalj_admin\resources\views/clinics/form.blade.php ENDPATH**/ ?>