
<?php $__env->startSection('title'); ?>
Order Details
<?php $__env->stopSection(); ?>
<?php $__env->startSection('css'); ?>
<!---Internal Fileupload css-->
<link href="<?php echo e(URL::asset('assets/plugins/fileuploads/css/fileupload.css')); ?>" rel="stylesheet" type="text/css"/>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
	<!-- row -->
	<div class="row row-sm mt-3">

		<!-- order start -->
		<div class="col-sm-12">
			<div class="card pt-4 box-shadow-0">
				<div class="card-body">

					<table class="table">
						<thead class="bg-primary py-3">
						  <tr>
							<th class="text-white py-3" scope="col">#Invoice</th>
							<th class="text-white py-3" scope="col"><?php echo e($order->invoice_no); ?></th>
						  </tr>
						</thead>
						<tbody>
						  <tr>
							<th scope="row">fullname</th>
							<td><?php echo e($order->first_name); ?> <?php echo e($order->last_name); ?></td>
						  </tr>
						  <tr>
							<th scope="row">phone</th>
							<td><?php echo e($order->phone); ?></td>
						  </tr>
						  <tr>
							<th scope="row">email</th>
							<td><?php echo e($order->email); ?></td>
						  </tr>
						  <tr>
							<th scope="row">address</th>
							<td><?php echo e($order->address); ?></td>
						  </tr>
						  <tr>
							<th scope="row">product name</th>
							<td><?php echo e($order->product_name); ?></td>
						  </tr>
						  <tr>
							<th scope="row">product price</th>
							<td><?php echo e($order->product_price); ?></td>
						  </tr>
						  <tr>
							<th scope="row">shipping fee</th>
							<td><?php echo e($order->shipping_fee); ?></td>
						  </tr>
						  <tr>
							<th scope="row">total price</th>
							<td><?php echo e($order->total_price); ?></td>
						  </tr>
						  <tr>
							<th scope="row">payment method</th>
							<td><?php echo e($order->payment_method); ?></td>
						  </tr>
						  <tr>
							<th scope="row">status</th>
							<td>
								<select class="form-control" name="order_status" id="order_status" data-order-id="<?php echo e($order->id); ?>">
									<option value="pending" <?php echo e($order->order_status == 'pending' ? 'selected' : ''); ?> >Pending</option>
									<option value="confirmed" <?php echo e($order->order_status == 'confirmed' ? 'selected' : ''); ?> >Confirmed</option>
									<option value="delivered" <?php echo e($order->order_status == 'delivered' ? 'selected' : ''); ?> >Delivered</option>
									<option value="canceled" <?php echo e($order->order_status == 'canceled' ? 'selected' : ''); ?> >Canceled</option>
								</select>
							</td>
						  </tr>
						  <tr>
							<th scope="row">date</th>
							<td><?php echo e(date('d M Y', strtotime($order->created_at))); ?></td>
						  </tr>
						  
						</tbody>
					</table>
	
				</div>
			</div>
		</div>
		<!-- order END -->


	</div>
	<!-- row -->

</div>
<!-- Container closed -->
</div>
<!-- main-content closed -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script>

	function updateOrderStatus(data) {

		var ajaxPromise = ajaxRequest('POST', "<?php echo e(url('admin/updateorderstatus')); ?>", data);

		ajaxPromise.done(function(response) {
			swalAlert(response.message, '' ,response.status);
		});

		ajaxPromise.fail(function(xhr, status, error) {
			swalAlert('Request failed', '' ,0);
			console.log('Request failed:', error);
		});

	}

	$('document').ready(function() {
		$('select[name="order_status"]').on("change", function() {
			
			let data = {
				"order_id" : $(this).data('order-id'),
				"order_status" : $(this).val(),
			};

			updateOrderStatus(data);
		});
	});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp\htdocs\maxethanol\admin\resources\views/orders/form.blade.php ENDPATH**/ ?>