
<?php $__env->startSection('title'); ?>
	<?php echo e(isset($booking) ? 'Edit Registration': 'Add Registration'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-header'); ?>
	<!-- breadcrumb -->
	<div class="breadcrumb-header justify-content-between">
		<div class="my-auto">
			<div class="d-flex">
				<h4 class="content-title mb-0 my-auto">Registration</h4><span class="text-muted mt-1 tx-13 mr-2 mb-0">/ <?php echo e(isset($booking) ? 'Edit': 'Create'); ?></span>
			</div>
			<?php if(isset($booking->user)): ?>
			<div class="d-flex">
				<h4 class="content-title text-dark mt-3 tx-16">Created By (<?php echo e($booking->user->name); ?>)</h4>
			</div>
			<?php endif; ?>
		</div>
	</div>
	<!-- breadcrumb -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

	<div class="loader-container hidden">
		<div class="spinner-border"></div>
	</div>

	<!-- row -->
	<div class="row row-sm">

		
		<div class="col-sm-12">
			<div class="card pt-4 box-shadow-0">
				<div class="card-body pt-0">
					<form class="form-horizontal row" id="booking-form" method="POST" action="<?php echo e(isset($booking) ? Route('bookings.update', ['booking'=>$booking->id]) : Route('bookings.store')); ?>" enctype="multipart/form-data">
						<?php echo csrf_field(); ?>


						<table class="table">
							<thead class="bg-primary py-3">
							  <tr>
								<th class="text-white py-3" scope="col">Item</th>
								<th class="text-white py-3" scope="col">Description</th>
							  </tr>
							</thead>
							<tbody>
							  <tr>
								<th scope="row">contact person <span class="text-danger">*</span></th>
								<td><input type="text" class="form-control" name="contact_person" required value="<?php echo e(isset($booking) ? $booking->contact_person : old('contact_person')); ?>" placeholder="Enter contact_person"></td>
							  </tr>
							  <tr>
								<th scope="row">company <span class="text-danger">*</span></th>
								<td><input type="text" class="form-control" name="company" required value="<?php echo e(isset($booking) ? $booking->company : old('company')); ?>" placeholder="Enter company"></td>
							  </tr>
							  <tr>
								<th scope="row">email <span class="text-danger">*</span></th>
								<td><input type="text" class="form-control" name="email" required value="<?php echo e(isset($booking) ? $booking->email : old('email')); ?>" placeholder="Enter email"></td>
							  </tr>
							  <tr>
								<th scope="row">mobile <span class="text-danger">*</span></th>
								<td><input type="text" class="form-control" name="mobile" required value="<?php echo e(isset($booking) ? $booking->mobile : old('mobile')); ?>" placeholder="Enter mobile"></td>
							  </tr>
							  <tr>
								<th scope="row">source of knowledge <span class="text-danger">*</span></th>
								<td>
									<?php isset($booking) ? $src_of_know = $booking->source_of_knowledge :  $src_of_know = '';?>
									<select name="source_of_knowledge" required class="form-control">
										<option value="" disabled selected>Choose One</option>
										<option value="Newspapers" <?php echo e($src_of_know == 'Newspapers' ? 'selected' : ''); ?>>Newspapers (صحف)</option>
										<option value="Phone Call" <?php echo e($src_of_know == 'Phone Call' ? 'selected' : ''); ?>>Phone Call (اتصال تليفوني)</option>
										<option value="Radio" <?php echo e($src_of_know == 'Radio' ? 'selected' : ''); ?>>Radio (راديو)</option>
										<option value="Facebook" <?php echo e($src_of_know == 'Facebook' ? 'selected' : ''); ?>>Facebook (فيسبوك)</option>
										<option value="Outdoor" <?php echo e($src_of_know == 'Outdoor' ? 'selected' : ''); ?>>Outdoor (أوت دور)</option>
										<option value="SMS" <?php echo e($src_of_know == 'SMS' ? 'selected' : ''); ?>>SMS (رسائل موبايل)</option>
										<option value="Invitaion" <?php echo e($src_of_know == 'Invitaion' ? 'selected' : ''); ?>>Invitaion (دعوة)</option>
										<option value="Others" <?php echo e($src_of_know == 'Others' ? 'selected' : ''); ?>>Others (أخري)</option>
									</select>
									<input type="text" class="form-control mt-2 hidden" name="other_src" required value="<?php echo e(isset($booking) ? $booking->other_src : old('other_src')); ?>" placeholder="Type source of knowledge">
								</td>
							  </tr>
							  <tr>
								<th scope="row">company activity</th>
								<td><input type="text" class="form-control" name="company_activity" value="<?php echo e(isset($booking) ? $booking->company_activity : old('company_activity')); ?>" placeholder="Enter company_activity"></td>
							  </tr>
							  <tr>
								<th scope="row">title</th>
								<td><input type="text" class="form-control" name="title" value="<?php echo e(isset($booking) ? $booking->title : old('title')); ?>" placeholder="Enter title"></td>
							  </tr>
							  <tr>
								<th scope="row">address</th>
								<td><input type="text" class="form-control" name="address" value="<?php echo e(isset($booking) ? $booking->address : old('address')); ?>" placeholder="Enter address"></td>
							  </tr>
							  <tr>
								<th scope="row">company_telephone</th>
								<td><input type="text" class="form-control" name="company_telephone" value="<?php echo e(isset($booking) ? $booking->company_telephone : old('company_telephone')); ?>" placeholder="Enter company_telephone"></td>
							  </tr>

							<?php if(isset($booking->qrcode->time_in)): ?>
							<tr>
								<th scope="row">Check-in</th>
								<td><?php echo e(date('d M Y - h:i a', strtotime($booking->qrcode->time_in))); ?></td>
							</tr>
							<?php endif; ?>
							<?php if(isset($booking->qrcode->time_out)): ?>
							<tr>
								<th scope="row">Check-out</th>
								<td><?php echo e(date('d M Y - h:i a', strtotime($booking->qrcode->time_out))); ?></td>
							</tr>
							<?php endif; ?>

							<?php if(isset($booking)): ?>
							<?php $print_badge = $booking->printBadge($booking->id); ?>
							<?php if($print_badge['count'] > 0): ?>
							<tr>
								<th scope="row">Print Badge Stats</th>
								<td><?php echo e($print_badge['date']); ?> ,, Total Prints <span class="text-primary">(<?php echo e($print_badge['count']); ?>)</span></td>
							</tr>
							<?php endif; ?>
							<?php endif; ?>
							

							</tbody>
						</table>

						<div class="form-group col-12 mb-0 mt-3 justify-content-end">
							<div>
								<button type="submit" class="btn btn-primary <?php echo e(isset($booking) ? '': 'create-booking'); ?>"><?php echo e(isset($booking) ? 'Update': 'Create'); ?></button>
							</div>
						</div>
					</form>
				</div>
			</div>
		</div>

	</div>
	<!-- row -->

</div>
<!-- Container closed -->
</div>
<!-- main-content closed -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>

<!--sweetalert js -->
<script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
<script>

	function formValidationCheck($form) {
		var status = 1;
		var message;
		$form.each(function(){
			var input = $(this);
			if( $(this).prop('required') && $(this).val() == '') {
				inputName = $(this).attr('name');
				message = inputName + " field can't be empty";
				status = 0;
			}
		});

		return {
			'status' : status,
			'message' : message,
		};
	}

	function source_of_knowledge($this) {
		// If Selected option value equal 'Others', Show other_src input
		if( $this.val() == 'Others' ) {
			$('input[name="other_src"]').fadeIn().prop('required', true);
		} else {
			$('input[name="other_src"]').fadeOut().prop('required', false).val('');
		}
	}


	$(document).ready(function() {
		$.ajaxSetup({
			headers: {
				'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
			} 
		});

		// Form Submit
		$('.create-booking').on('click', function(e) {
			e.preventDefault();
			
			var formData = $("#booking-form").serialize();
			var formValidationRes = formValidationCheck( $("#booking-form :input") );
			if(formValidationRes['status'] == 0) {

				swalAlert(formValidationRes['message'], '' ,2);
				
			} else {

				var ajaxPromise = ajaxRequest("POST", "<?php echo e(route('bookings.store')); ?>", formData);

				ajaxPromise.done(function(response) {
					if(response.status == 1) {
						print_record(response.record_id, 'label');
					} else {
						swalAlert(response.message, '' ,0);
					}
				});

				ajaxPromise.fail(function(xhr, status, error) {
					swalAlert('Request failed', '' ,0);
					console.log('Request failed:', error);
				});

			}
		});

		// When Page Load Call source_of_knowledge function
		$source_of_knowledge = $('select[name="source_of_knowledge"]');
		source_of_knowledge($source_of_knowledge);

		// When a change occurs in select box Call source_of_knowledge function
		$('select[name="source_of_knowledge"]').on('change', function() {
			source_of_knowledge($(this));
		});

	});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp\htdocs\hvac_admin\resources\views/bookings/form.blade.php ENDPATH**/ ?>