
<?php $__env->startSection('title'); ?>
	<?php echo e(isset($pharmacyCategory) ? 'Edit Pharmacy Category': 'Add Pharmacy Category'); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('css'); ?>
<!-- Internal Select2 css -->
<link href="<?php echo e(URL::asset('assets/plugins/select2/css/select2.min.css')); ?>" rel="stylesheet">
<!--Internal  Datetimepicker-slider css -->
<link href="<?php echo e(URL::asset('assets/plugins/amazeui-datetimepicker/css/amazeui.datetimepicker.css')); ?>" rel="stylesheet">
<link href="<?php echo e(URL::asset('assets/plugins/jquery-simple-datetimepicker/jquery.simple-dtpicker.css')); ?>" rel="stylesheet">
<link href="<?php echo e(URL::asset('assets/plugins/pickerjs/picker.min.css')); ?>" rel="stylesheet">
<!---Internal Fileupload css-->
<link href="<?php echo e(URL::asset('assets/plugins/fileuploads/css/fileupload.css')); ?>" rel="stylesheet" type="text/css"/>

<!-- Internal Spectrum-colorpicker css -->
<link href="<?php echo e(URL::asset('assets/plugins/spectrum-colorpicker/spectrum.css')); ?>" rel="stylesheet">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('page-header'); ?>
	<!-- breadcrumb -->
	<div class="breadcrumb-header justify-content-between">
		<div class="my-auto">
			<div class="d-flex">
				<h4 class="content-title mb-0 my-auto">Pharmacy Category</h4><span class="text-muted mt-1 tx-13 mr-2 mb-0">/ <?php echo e(isset($pharmacyCategory) ? 'Edit': 'Create'); ?></span>
			</div>
		</div>
	</div>
	<!-- breadcrumb -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
	<!-- row -->
	<div class="row row-sm">

		
		<div class="col-sm-12">
			<div class="card pt-4 box-shadow-0">
				<div class="card-body pt-0">
					<form class="form-horizontal row" method="POST" action="<?php echo e(isset($pharmacyCategory) ? Route('pharmacy_categories.update', ['pharmacy_category'=>$pharmacyCategory->id]) : Route('pharmacy_categories.store')); ?>" enctype="multipart/form-data">
						<?php echo csrf_field(); ?>

						<div class="col-12">
							<?php if($errors->has('img')): ?>
								<p class="help text-danger"><?php echo e($errors->first('img')); ?></p>
							<?php endif; ?>
							<?php if($errors->has('img_ar')): ?>
								<p class="help text-danger"><?php echo e($errors->first('img_ar')); ?></p>
							<?php endif; ?>
							<?php if($errors->has('name')): ?>
								<p class="help text-danger"><?php echo e($errors->first('name')); ?></p>
							<?php endif; ?>
						</div>
						<div class="form-group col-4">
							<label class="text-capitalize" for="type">Type</label>
							<select name="type" class="form-control" required>
								<?php isset($pharmacyCategory) ? $pharmacyCategoryType = $pharmacyCategory->type : $pharmacyCategoryType = ''; ?>
								<option value="txt" <?php echo e($pharmacyCategoryType == 'txt' ? 'selected' : ''); ?>>Text</option>
								<option value="img" <?php echo e($pharmacyCategoryType == 'img' ? 'selected' : ''); ?>>Image</option>
							</select>
							<?php if($errors->has('type')): ?>
								<p class="help text-danger"><?php echo e($errors->first('type')); ?></p>
							<?php endif; ?>
						</div>

						<div class="form-group col-4">
							<label class="text-capitalize" for="parent">Parent (**Leave the value empty if main category)</label>
							<input type="number" class="form-control" name="parent" id="parent" value="<?php echo e(isset($pharmacyCategory) ? $pharmacyCategory->parent : old('parent')); ?>" placeholder="Enter parent ID">
							<?php if($errors->has('parent')): ?>
								<p class="help text-danger"><?php echo e($errors->first('parent')); ?></p>
							<?php endif; ?>
						</div>

						<div class="form-group col-4">
							<label class="text-capitalize" for="status">Status</label>
							<select name="status" class="form-control">
								<?php isset($pharmacyCategory) ? $status = $pharmacyCategory->status : $status = ''; ?>
								<option value="">In-Active</option>
								<option value="1" <?php echo e($status == 1 ? 'selected' : ''); ?>>Active</option>
							</select>
							<?php if($errors->has('status')): ?>
								<p class="help text-danger"><?php echo e($errors->first('status')); ?></p>
							<?php endif; ?>
						</div>

						<div id="type_txt_container" class="col-12 toggleContainer hidden" data-type="txt">
							<div class="row">
								<div class="form-group col-12">
									<label class="text-capitalize" for="name">Name</label>
									<input type="text" class="form-control toggleValue" name="name" id="name" value="<?php echo e(isset($pharmacyCategory) ? $pharmacyCategory->name : old('name')); ?>" placeholder="Enter Name">
									<?php if($errors->has('name')): ?>
										<p class="help text-danger"><?php echo e($errors->first('name')); ?></p>
									<?php endif; ?>
								</div>
		
								<div class="form-group col-12">
									<label class="text-capitalize" for="name_ar">Arabic Name</label>
									<input type="text" class="form-control toggleValue" name="name_ar" id="name_ar" value="<?php echo e(isset($pharmacyCategory) ? $pharmacyCategory->name_ar : old('name_ar')); ?>" placeholder="Enter Arabic Name">
									<?php if($errors->has('name_ar')): ?>
										<p class="help text-danger"><?php echo e($errors->first('name_ar')); ?></p>
									<?php endif; ?>
								</div>
							</div>
							
						</div>
						
						<div id="type_img_container" class="col-12 toggleContainer hidden" data-type="img">
							<div class="row">
								<!-- Image Upload -->
								<div class="col-12">
									<div class="row">

										<div class="col-md-12">
											<div class="card">
												<div class="card-body">
													<div>
														<h6 class="card-title mb-1">Image Upload</h6>
													</div>
													<div class="row mb-4">
														<?php if(isset($pharmacyCategory) && $pharmacyCategory->type == 'img' && $pharmacyCategory->name): ?>
														<div class="col-lg-4 col-md-12 mb-4 mb-lg-0">
															<img
																src="https://apis.moalj.com<?php echo e($pharmacyCategory->name); ?>"
																class="shadow-1-strong rounded mb-4 img-fluid"
																alt="img"
																style="max-height: 210px; min-height: 210px;"
															/>
														</div>
														<?php endif; ?>
														<div class="col-sm-12 col-md-4">
															<input type="file" name="img" class="dropify toggleValue" data-height="200" />
														</div>
													</div>
												</div>
											</div>
										</div>

										<div class="col-md-12">
											<div class="card">
												<div class="card-body">
													<div>
														<h6 class="card-title mb-1">Arabic Image Upload</h6>
													</div>
													<div class="row mb-4">
														<?php if(isset($pharmacyCategory) && $pharmacyCategory->type == 'img' && $pharmacyCategory->name_ar): ?>
														<div class="col-lg-4 col-md-12 mb-4 mb-lg-0">
															<img
																src="https://apis.moalj.com<?php echo e($pharmacyCategory->name_ar); ?>"
																class="shadow-1-strong rounded mb-4 img-fluid"
																alt="img_ar"
																style="max-height: 210px; min-height: 210px;"
															/>
														</div>
														<?php endif; ?>
														<div class="col-sm-12 col-md-4">
															<input type="file" name="img_ar" class="dropify toggleValue" data-height="200" />
														</div>
													</div>
												</div>
											</div>
										</div>

									</div>
								</div>
								<!-- Image Upload closed -->
							</div>
						
						</div>

						<div class="form-group col-12 mb-0 mt-3 justify-content-end">
							<div>
								<button type="submit" class="btn btn-primary"><?php echo e(isset($pharmacyCategory) ? 'Update': 'Create'); ?></button>
							</div>
						</div>
					</form>
				</div>
			</div>
		</div>

		<?php if(isset($doctors) && count($doctors) > 0): ?>
		
		<div class="col-xl-12">
			<div class="card">
				<div class="card-header pb-0">
					<div class="d-flex justify-content-between">
						<h4 class="card-title mg-b-0">Registered Doctors TABLE <span class="text-primary mt-1 tx-13 ml-1 mb-0">(<?php echo e(count($doctors)); ?>) Doctors</span></h4>
						<i class="mdi mdi-dots-horizontal text-gray"></i>
					</div>
				</div>
				<div class="card-body">
					<div class="table-responsive">
						<table class="table text-md-nowrap" id="example1">
							<thead>
								<tr>
									<th class="all border-bottom-0">#</th>
									<th class="all border-bottom-0">Name</th>
									<th class="all border-bottom-0">pharmacyCategory</th>
									<th class="all border-bottom-0">Sub pharmacyCategory</th>
									<th class="all border-bottom-0">Governorate</th>
									<th class="all border-bottom-0">Cost</th>
									<th class="all border-bottom-0">Type</th>
									<th class="all border-bottom-0">Action</th>
								</tr>
							</thead>
							<tbody>
								<?php $__currentLoopData = $doctors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $doctor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
								<tr>
									<td><?php echo e($doctor->id); ?></td>
									<td><?php echo e($doctor->name); ?></td>
									<td><?php echo e($doctor->pharmacyCategory); ?></td>
									<td><?php echo e($doctor->sub_specialties); ?></td>
									<td><?php echo e(isset($doctor->governorate) ? $doctor->governorate->governorate_name_en : 'Undefined'); ?></td>
									<td><?php echo e($doctor->cost); ?></td>
									<td><?php echo e($doctor->type); ?></td>
									<td>
										<a href="<?php echo e(url('/admin/doctors/'.$doctor->id)); ?>" class="mr-3"><i class="fa-solid fa-pen-to-square"></i></a>
									</td>
								</tr>
								<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
							</tbody>
						</table>
					</div>
				</div>
			</div>
		</div>
		<?php endif; ?>

	</div>
	<!-- row -->

</div>
<!-- Container closed -->
</div>
<!-- main-content closed -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<!--Internal  Datepicker js -->
<script src="<?php echo e(URL::asset('assets/plugins/jquery-ui/ui/widgets/datepicker.js')); ?>"></script>
<!--Internal Fileuploads js-->
<script src="<?php echo e(URL::asset('assets/plugins/fileuploads/js/fileupload.js')); ?>"></script>
<script src="<?php echo e(URL::asset('assets/plugins/fileuploads/js/file-upload.js')); ?>"></script>

<!--Internal dynamicrows js-->
<script src="<?php echo e(URL::asset('assets/js/dynamicrows.js')); ?>"></script>

<!--Internal  jquery.maskedinput js -->
<script src="<?php echo e(URL::asset('assets/plugins/jquery.maskedinput/jquery.maskedinput.js')); ?>"></script>
<!--Internal  spectrum-colorpicker js -->
<script src="<?php echo e(URL::asset('assets/plugins/spectrum-colorpicker/spectrum.js')); ?>"></script>
<!-- Internal Select2.min js -->
<script src="<?php echo e(URL::asset('assets/plugins/select2/js/select2.min.js')); ?>"></script>
<!--Internal Ion.rangeSlider.min js -->
<script src="<?php echo e(URL::asset('assets/plugins/ion-rangeslider/js/ion.rangeSlider.min.js')); ?>"></script>
<!--Internal  jquery-simple-datetimepicker js -->
<script src="<?php echo e(URL::asset('assets/plugins/amazeui-datetimepicker/js/amazeui.datetimepicker.min.js')); ?>"></script>
<!-- Ionicons js -->
<script src="<?php echo e(URL::asset('assets/plugins/jquery-simple-datetimepicker/jquery.simple-dtpicker.js')); ?>"></script>
<!--Internal  pickerjs js -->
<script src="<?php echo e(URL::asset('assets/plugins/pickerjs/picker.min.js')); ?>"></script>
<!-- Internal form-elements js -->
<script src="<?php echo e(URL::asset('assets/js/form-elements.js')); ?>"></script>


<script>
	$(document).ready(function() {

		//  Toggle Display Image/text Container

		var containerType = $('select[name="type"]').val();
		$('.toggleContainer').each(function() {
			if( $(this).data('type') == containerType ) {
				$(this).fadeIn();
			}
		});

		$('select[name="type"]').on('change', function() {
			var containerType = $(this).val();

			$('.toggleContainer').each(function() {
				if( $(this).data('type') == containerType ) {
					$('.toggleValue').val('');
					$('.toggleContainer').fadeOut();
					$(this).fadeIn();
				}
			});

		});
	});
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp\htdocs\moalj_admin\resources\views/pharmacy_categories/form.blade.php ENDPATH**/ ?>