<?php

namespace App\Http\Controllers;

use App\Models\Customer;
use Illuminate\Http\Request;

class CustomerController extends Controller
{
    public function index(Request $request) {

        $page = $request->page;

        if(isset($page) && is_numeric($page) && $page>0) {

            $records_to_show = 25;
            $records_to_skip = ($page - 1) * $records_to_show;

            $query = Customer::query();

            if($request->filter) {
                $query = $this->filter($request, $query);
            }

            $all_records_count = $query->count();

            $num_of_pages = (int) ceil($all_records_count / $records_to_show);
            
            $customers = $query->skip($records_to_skip)->take($records_to_show)->get();

            return view('customers.index', compact('customers','num_of_pages', 'page'));

            
        } else {
            return redirect()->route('customers.index', ['page'=>1]);
        }
    }

    public function filter($request, $query) {

        $request->phone != null ? $query->where('phoneNumber', 'like' ,'%'.$request->phone.'%') : '';
        $request->fullname != null ? $query->where('fullname', 'like' ,'%'.$request->fullname.'%') : '';
        $request->created_at != null ? $query->whereDate('date_add', '=',  $request->created_at) : '';

        return $query;
    }

    public function show($id) {

        $customer = Customer::where('id_customer', $id)->with('health_info')->first();
        
        return view('customers.form', compact('customer'));
    }

    public function updateCustomerStatus(Request $request) {
        $status = 0;
        $message = "Something went wrong.";

        $update = Customer::where('id_customer', $request->customer_id)->update(["active" => $request->active]);

        if($update) {
            $status = 1;
            $message = "Customer status updated successfully.";
        }
        return response()->json([
            "status" => $status,
            "message" => $message
        ]);
    }

}
